/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerElectrolyticSeparator;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElectrolyticSeparator
extends GuiMekanismTile<TileEntityElectrolyticSeparator> {
    public GuiDisableableButton LeftMode;
    public GuiDisableableButton RightMode;

    public GuiElectrolyticSeparator(InventoryPlayer inventory, TileEntityElectrolyticSeparator tile) {
        super(tile, new ContainerElectrolyticSeparator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String usage = MekanismUtils.getEnergyDisplay(((TileEntityElectrolyticSeparator)this.tileEntity).clientEnergyUsed);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + usage + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityElectrolyticSeparator)this.tileEntity).getMaxEnergy() - ((TileEntityElectrolyticSeparator)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityElectrolyticSeparator)this.tileEntity).fluidTank, GuiGauge.Type.STANDARD, this, resource, 5, 10).withColor(GuiGauge.TypeColor.RED));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityElectrolyticSeparator)this.tileEntity).leftTank, GuiGauge.Type.SMALL, this, resource, 58, 18).withColor(GuiGauge.TypeColor.BLUE));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityElectrolyticSeparator)this.tileEntity).rightTank, GuiGauge.Type.SMALL, this, resource, 100, 18).withColor(GuiGauge.TypeColor.AQUA));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 25, 34));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, resource, 58, 51));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.AQUA, this, resource, 100, 51));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityElectrolyticSeparator)GuiElectrolyticSeparator.this.tileEntity).getActive() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.BI, this, resource, 78, 29));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.LeftMode = new GuiDisableableButton(0, this.field_147003_i + 7, this.field_147009_r + 72, 10, 10, () -> ((TileEntityElectrolyticSeparator)this.tileEntity).dumpLeft.ordinal()).with(GuiDisableableButton.ImageOverlay.GAS_MOD);
        this.field_146292_n.add(this.LeftMode);
        this.RightMode = new GuiDisableableButton(1, this.field_147003_i + 159, this.field_147009_r + 72, 10, 10, () -> ((TileEntityElectrolyticSeparator)this.tileEntity).dumpRight.ordinal()).with(GuiDisableableButton.ImageOverlay.GAS_MOD);
        this.field_146292_n.add(this.RightMode);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.LeftMode.field_146127_k) {
            TileNetworkList data = TileNetworkList.withContents((byte)0);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        } else if (guibutton.field_146127_k == this.RightMode.field_146127_k) {
            TileNetworkList data = TileNetworkList.withContents((byte)1);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityElectrolyticSeparator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityElectrolyticSeparator)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        String name = LangUtils.localize(((TileEntityElectrolyticSeparator)this.tileEntity).dumpLeft.getLangKey());
        this.renderScaledText(name, 21, 73, 0x404040, 66);
        name = LangUtils.localize(((TileEntityElectrolyticSeparator)this.tileEntity).dumpRight.getLangKey());
        this.renderScaledText(name, 156 - (int)((float)this.field_146289_q.func_78256_a(name) * this.getNeededScale(name, 66)), 73, 0x404040, 66);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean outRight;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityElectrolyticSeparator)this.tileEntity).getEnergy() < ((TileEntityElectrolyticSeparator)this.tileEntity).energyPerTick || ((TileEntityElectrolyticSeparator)this.tileEntity).getEnergy() == 0.0;
            boolean outLeft = ((TileEntityElectrolyticSeparator)this.tileEntity).leftTank.getStored() == ((TileEntityElectrolyticSeparator)this.tileEntity).leftTank.getMaxGas();
            boolean bl = outRight = ((TileEntityElectrolyticSeparator)this.tileEntity).rightTank.getStored() == ((TileEntityElectrolyticSeparator)this.tileEntity).rightTank.getMaxGas();
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (outLeft) {
                info.add(LangUtils.localize("gui.gas_no_space"));
            }
            if (outRight) {
                info.add(LangUtils.localize("gui.gas_no_space"));
            }
            if (outLeft || energy || outRight) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean outRight;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        boolean energy = ((TileEntityElectrolyticSeparator)this.tileEntity).getEnergy() < ((TileEntityElectrolyticSeparator)this.tileEntity).energyPerTick || ((TileEntityElectrolyticSeparator)this.tileEntity).getEnergy() == 0.0;
        boolean outLeft = ((TileEntityElectrolyticSeparator)this.tileEntity).leftTank.getStored() == ((TileEntityElectrolyticSeparator)this.tileEntity).leftTank.getMaxGas();
        boolean bl = outRight = ((TileEntityElectrolyticSeparator)this.tileEntity).rightTank.getStored() == ((TileEntityElectrolyticSeparator)this.tileEntity).rightTank.getMaxGas();
        if (outLeft) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 58 + 10, this.field_147009_r + 18 + 1, 0, 0, 7, 28);
        }
        if (outRight) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 100 + 10, this.field_147009_r + 18 + 1, 0, 0, 7, 28);
        }
        if (energy || outLeft || outRight) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }
}

