/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.GuiTextColorField;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiElementScreen;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDigitalMinerConfig
extends GuiFilterHolder<TileEntityDigitalMiner, MinerFilter> {
    private GuiTextColorField radiusField;
    private GuiTextColorField minField;
    private GuiTextColorField maxField;
    private GuiDisableableButton newFilterButton;
    private GuiDisableableButton backButton;
    private GuiDisableableButton setRadiButton;
    private GuiDisableableButton setMinButton;
    private GuiDisableableButton setMaxButton;
    private GuiDisableableButton inverseButton;

    public GuiDigitalMinerConfig(EntityPlayer player, TileEntityDigitalMiner tile) {
        super(tile, new ContainerNull(player, tile));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 10, 17, 45, 140));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 55, 17, 98, 118));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 55, 135, 98, 22));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 153, 17, 14, 140));
    }

    @Override
    protected HashList<MinerFilter> getFilters() {
        return ((TileEntityDigitalMiner)this.tileEntity).filters;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.radiusField.updateCursorCounter();
        this.minField.updateCursorCounter();
        this.maxField.updateCursorCounter();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.setRadiButton.field_146124_l = !this.radiusField.getText().isEmpty();
        this.setMinButton.field_146124_l = !this.minField.getText().isEmpty();
        this.setMaxButton.field_146124_l = !this.maxField.getText().isEmpty();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.radiusField.mouseClicked(mouseX, mouseY, button);
        this.minField.mouseClicked(mouseX, mouseY, button);
        this.maxField.mouseClicked(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - this.field_147003_i;
            int yAxis = mouseY - this.field_147009_r;
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (this.needsScrollBars()) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 4; ++i) {
                int index = this.getFilterIndex() + i;
                IFilter filter = ((TileEntityDigitalMiner)this.tileEntity).filters.get(index);
                if (filter == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                int arrowX = 140;
                if (index > 0 && xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 1 && yAxis <= yStart + 7) {
                    this.sendDataFromClick(TileNetworkList.withContents(11, index));
                    return;
                }
                if (index < ((TileEntityDigitalMiner)this.tileEntity).filters.size() - 1 && xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 21 && yAxis <= yStart + 27) {
                    this.sendDataFromClick(TileNetworkList.withContents(12, index));
                    return;
                }
                if (filter instanceof IItemStackFilter) {
                    this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 1, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (filter instanceof IOreDictFilter) {
                    this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 2, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (filter instanceof IMaterialFilter) {
                    this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 3, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (!(filter instanceof IModIDFilter)) continue;
                this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 6, index, SoundEvents.field_187909_gi);
            }
        }
    }

    private void sendPacket(PacketDigitalMinerGui.MinerGuiPacket type, int guiID, int extra, @Nullable SoundEvent sound) {
        Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(type, Coord4D.get(this.tileEntity), guiID, extra, 0));
        if (sound != null) {
            SoundHandler.playSound(sound);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.newFilterButton = new GuiDisableableButton(0, this.field_147003_i + 56, this.field_147009_r + 136, 96, 20, LangUtils.localize("gui.newFilter"));
        this.field_146292_n.add(this.newFilterButton);
        this.backButton = new GuiDisableableButton(1, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11).with(GuiDisableableButton.ImageOverlay.SMALL_BACK);
        this.field_146292_n.add(this.backButton);
        this.setRadiButton = new GuiDisableableButton(2, this.field_147003_i + 39, this.field_147009_r + 67, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK_DIGITAL);
        this.field_146292_n.add(this.setRadiButton);
        this.setMinButton = new GuiDisableableButton(3, this.field_147003_i + 39, this.field_147009_r + 92, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK_DIGITAL);
        this.field_146292_n.add(this.setMinButton);
        this.setMaxButton = new GuiDisableableButton(4, this.field_147003_i + 39, this.field_147009_r + 117, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK_DIGITAL);
        this.field_146292_n.add(this.setMaxButton);
        this.inverseButton = new GuiDisableableButton(5, this.field_147003_i + 11, this.field_147009_r + 141, 14, 14).with(GuiDisableableButton.ImageOverlay.INVERSE);
        this.field_146292_n.add(this.inverseButton);
        String prevRad = this.radiusField != null ? this.radiusField.getText() : "";
        String prevMin = this.minField != null ? this.minField.getText() : "";
        String prevMax = this.maxField != null ? this.maxField.getText() : "";
        this.radiusField = new GuiTextColorField(1, this.field_146289_q, this.field_147003_i + 12, this.field_147009_r + 67, 38, 11);
        this.radiusField.setMaxStringLength(Integer.toString(MekanismConfig.current().general.digitalMinerMaxRadius.val()).length());
        this.radiusField.setFocusedboxbordercolor(-14378916);
        this.radiusField.setBoxbordercolor(-12779878);
        this.radiusField.setTextColor(-12779878);
        this.radiusField.setText(prevRad);
        this.minField = new GuiTextColorField(2, this.field_146289_q, this.field_147003_i + 12, this.field_147009_r + 92, 38, 11);
        this.minField.setMaxStringLength(3);
        this.minField.setFocusedboxbordercolor(-14378916);
        this.minField.setBoxbordercolor(-12779878);
        this.minField.setTextColor(-12779878);
        this.minField.setText(prevMin);
        this.maxField = new GuiTextColorField(3, this.field_146289_q, this.field_147003_i + 12, this.field_147009_r + 117, 38, 11);
        this.maxField.setMaxStringLength(3);
        this.maxField.setFocusedboxbordercolor(-14378916);
        this.maxField.setBoxbordercolor(-12779878);
        this.maxField.setTextColor(-12779878);
        this.maxField.setText(prevMax);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.newFilterButton.field_146127_k) {
            this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER, 5, 0, null);
        } else if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER, 4, 0, null);
        } else if (guibutton.field_146127_k == this.setRadiButton.field_146127_k) {
            this.setRadius();
        } else if (guibutton.field_146127_k == this.setMinButton.field_146127_k) {
            this.setMinY();
        } else if (guibutton.field_146127_k == this.setMaxButton.field_146127_k) {
            this.setMaxY();
        } else if (guibutton.field_146127_k == this.inverseButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(10)));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String config = LangUtils.localize("gui.digitalMinerConfig");
        this.field_146289_q.func_78276_b(config, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(config) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.filters") + ":", 11, 19, -12779878);
        this.field_146289_q.func_78276_b("T: " + ((TileEntityDigitalMiner)this.tileEntity).filters.size(), 11, 28, -12779878);
        this.field_146289_q.func_78276_b("I: " + LangUtils.transOnOff(((TileEntityDigitalMiner)this.tileEntity).inverse), 11, 131, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.radi") + ": " + ((TileEntityDigitalMiner)this.tileEntity).getRadius(), 11, 58, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.min") + ": " + ((TileEntityDigitalMiner)this.tileEntity).minY, 11, 83, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.max") + ": " + ((TileEntityDigitalMiner)this.tileEntity).maxY, 11, 108, -12779878);
        for (int i = 0; i < 4; ++i) {
            IFilter filter = ((TileEntityDigitalMiner)this.tileEntity).filters.get(this.getFilterIndex() + i);
            if (filter == null) continue;
            int yStart = i * 29 + 18;
            if (filter instanceof IItemStackFilter) {
                this.renderItem(((IItemStackFilter)filter).getItemStack(), 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (filter instanceof IOreDictFilter) {
                IOreDictFilter oreFilter = (IOreDictFilter)filter;
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                this.renderItem(((GuiFilterHolder.StackData)this.oreDictStacks.get((Object)filter)).renderStack, 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (filter instanceof IMaterialFilter) {
                this.renderItem(((IMaterialFilter)filter).getMaterialItem(), 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (!(filter instanceof IModIDFilter)) continue;
            IModIDFilter modFilter = (IModIDFilter)filter;
            if (!this.modIDStacks.containsKey(modFilter)) {
                this.updateStackList(modFilter);
            }
            this.renderItem(((GuiFilterHolder.StackData)this.modIDStacks.get((Object)filter)).renderStack, 59, yStart + 3);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
        }
        if (this.inverseButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.inverse"), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.radiusField.drawTextBox();
        this.minField.drawTextBox();
        this.maxField.drawTextBox();
        MekanismRenderer.resetColor();
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.radiusField.isFocused() && !this.minField.isFocused() && !this.maxField.isFocused() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28) {
            if (this.radiusField.isFocused()) {
                this.setRadius();
            } else if (this.minField.isFocused()) {
                this.setMinY();
            } else if (this.maxField.isFocused()) {
                this.setMaxY();
            }
        }
        if (Character.isDigit(c) || GuiDigitalMinerConfig.isTextboxKey(c, i)) {
            this.radiusField.textboxKeyTyped(c, i);
            this.minField.textboxKeyTyped(c, i);
            this.maxField.textboxKeyTyped(c, i);
        }
    }

    private void setRadius() {
        if (!this.radiusField.getText().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.radiusField.getText()), MekanismConfig.current().general.digitalMinerMaxRadius.val()));
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(6, toUse)));
            this.radiusField.setText("");
        }
    }

    private void setMinY() {
        if (!this.minField.getText().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.minField.getText()), ((TileEntityDigitalMiner)this.tileEntity).maxY));
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(7, toUse)));
            this.minField.setText("");
        }
    }

    private void setMaxY() {
        if (!this.maxField.getText().isEmpty()) {
            int toUse = Math.max(((TileEntityDigitalMiner)this.tileEntity).minY, Math.min(Integer.parseInt(this.maxField.getText()), 255));
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(8, toUse)));
            this.maxField.setText("");
        }
    }
}

