/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBarshort;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.inventory.container.ContainerDigitalMiner;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDigitalMiner
extends GuiMekanismTile<TileEntityDigitalMiner> {
    public static final int START_BUTTON_ID = 0;
    public static final int STOP_BUTTON_ID = 1;
    public static final int CONFIG_BUTTON_ID = 2;
    public static final int RESET_BUTTON_ID = 3;
    private GuiDisableableButton startButton;
    private GuiDisableableButton stopButton;
    private GuiDisableableButton configButton;
    private GuiDisableableButton resetButton;

    public GuiDigitalMiner(InventoryPlayer inventory, TileEntityDigitalMiner tile) {
        super(tile, new ContainerDigitalMiner(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBarshort((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 157, 38));
        this.addGuiElement(new GuiVisualsTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            double perTick = ((TileEntityDigitalMiner)this.tileEntity).getPerTick();
            String multiplier = MekanismUtils.getEnergyDisplay(perTick);
            ArrayList<String> ret = new ArrayList<String>(4);
            ret.add(LangUtils.localize("mekanism.gui.digitalMiner.capacity") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy()));
            ret.add(LangUtils.localize("gui.needed") + ": " + multiplier + "/t");
            if (perTick > ((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy()) {
                ret.add(TextFormatting.RED + LangUtils.localize("mekanism.gui.insufficientbuffer"));
            }
            ret.add(LangUtils.localize("mekanism.gui.bufferfree") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy() - ((TileEntityDigitalMiner)this.tileEntity).getEnergy()));
            return ret;
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 151, 19).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiInnerScreen(this, resource, 7, 19, 78, 69));
        this.addGuiElement(new GuiPlayerSlot(this, resource, 7, 159));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 7 + x * 18, 91 + y * 18));
            }
        }
        this.field_147000_g += 76;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int buttonStart = 19;
        this.startButton = new GuiDisableableButton(0, this.field_147003_i + 87, this.field_147009_r + buttonStart, 61, 18, LangUtils.localize("gui.start"));
        this.field_146292_n.add(this.startButton);
        this.stopButton = new GuiDisableableButton(1, this.field_147003_i + 87, this.field_147009_r + buttonStart + 17, 61, 18, LangUtils.localize("gui.stop"));
        this.field_146292_n.add(this.stopButton);
        this.configButton = new GuiDisableableButton(2, this.field_147003_i + 87, this.field_147009_r + buttonStart + 34, 61, 18, LangUtils.localize("gui.config"));
        this.field_146292_n.add(this.configButton);
        this.resetButton = new GuiDisableableButton(3, this.field_147003_i + 87, this.field_147009_r + buttonStart + 51, 61, 18, LangUtils.localize("gui.digitalMiner.reset"));
        this.field_146292_n.add(this.resetButton);
        this.updateEnabledButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        switch (guibutton.field_146127_k) {
            case 0: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3)));
                break;
            }
            case 1: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(4)));
                break;
            }
            case 2: {
                Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
                break;
            }
            case 3: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(5)));
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.startButton.field_146124_l = ((TileEntityDigitalMiner)this.tileEntity).searcher.state == ThreadMinerSearch.State.IDLE || !((TileEntityDigitalMiner)this.tileEntity).running;
        this.stopButton.field_146124_l = ((TileEntityDigitalMiner)this.tileEntity).searcher.state != ThreadMinerSearch.State.IDLE && ((TileEntityDigitalMiner)this.tileEntity).running;
        this.configButton.field_146124_l = ((TileEntityDigitalMiner)this.tileEntity).searcher.state == ThreadMinerSearch.State.IDLE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityDigitalMiner)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityDigitalMiner)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String runningType = ((TileEntityDigitalMiner)this.tileEntity).getPerTick() > ((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy() ? LangUtils.localize("mekanism.gui.digitalMiner.lowPower") : (((TileEntityDigitalMiner)this.tileEntity).running ? LangUtils.localize("gui.digitalMiner.running") : LangUtils.localize("gui.idle"));
        this.field_146289_q.func_78276_b(runningType, 9, 21, -12779878);
        this.field_146289_q.func_78276_b(((TileEntityDigitalMiner)this.tileEntity).searcher.state.localize(), 9, 31, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.toMine") + ": " + ((TileEntityDigitalMiner)this.tileEntity).clientToMine, 9, 41, -12779878);
        if (!((TileEntityDigitalMiner)this.tileEntity).missingStack.func_190926_b()) {
            this.drawColorIcon(64, 21, EnumColor.DARK_RED, 0.8f);
            this.renderItem(((TileEntityDigitalMiner)this.tileEntity).missingStack, 64, 21);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
            this.func_73729_b(64, 21, GuiSlot.SlotOverlay.CHECK.textureX, GuiSlot.SlotOverlay.CHECK.textureY, 18, 18);
        }
        this.renderText(LangUtils.localize("gui.on"), 17.0f, 37.5f);
        this.renderText(LangUtils.localize("gui.on"), 29.75f, 37.5f);
        this.renderText(LangUtils.localize("gui.on"), 42.5f, 37.5f);
        this.renderText(LangUtils.localize("gui.off"), 17.0f, 43.5f);
        this.renderText(LangUtils.localize("gui.off"), 29.75f, 43.5f);
        this.renderText(LangUtils.localize("gui.off"), 42.5f, 43.5f);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.autoEjectButtoninBounds(xAxis, yAxis)) {
            this.displayTooltip(LangUtils.localize("gui.autoEject") + ":" + LangUtils.transOnOff(((TileEntityDigitalMiner)this.tileEntity).doEject), xAxis, yAxis);
        } else if (this.autoPullButtoninBounds(xAxis, yAxis)) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.autoPull") + ":" + LangUtils.transOnOff(((TileEntityDigitalMiner)this.tileEntity).doPull), xAxis, yAxis);
        } else if (this.silkTouchButtoninBounds(xAxis, yAxis)) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.silkTouch") + ":" + LangUtils.transOnOff(((TileEntityDigitalMiner)this.tileEntity).silkTouch), xAxis, yAxis);
        } else if (xAxis >= 64 && xAxis <= 80 && yAxis >= 21 && yAxis <= 37) {
            if (!((TileEntityDigitalMiner)this.tileEntity).missingStack.func_190926_b()) {
                this.displayTooltip(LangUtils.localize("gui.digitalMiner.missingBlock"), xAxis, yAxis);
            } else {
                this.displayTooltip(LangUtils.localize("gui.well"), xAxis, yAxis);
            }
        } else if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean energy;
            ArrayList<String> info = new ArrayList<String>();
            boolean bl = energy = ((TileEntityDigitalMiner)this.tileEntity).getEnergy() < ((TileEntityDigitalMiner)this.tileEntity).energyUsage || ((TileEntityDigitalMiner)this.tileEntity).getEnergy() == 0.0;
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (energy) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SWITCH, "switch_icon.png"));
        this.func_73729_b(this.field_147003_i + 19, this.field_147009_r + 56, 0, ((TileEntityDigitalMiner)this.tileEntity).doEject ? 0 : 8, 15, 8);
        this.func_73729_b(this.field_147003_i + 19, this.field_147009_r + 56 + 8 + 1, 0, !((TileEntityDigitalMiner)this.tileEntity).doEject ? 0 : 8, 15, 8);
        this.func_73729_b(this.field_147003_i + 38, this.field_147009_r + 56, 0, ((TileEntityDigitalMiner)this.tileEntity).doPull ? 0 : 8, 15, 8);
        this.func_73729_b(this.field_147003_i + 38, this.field_147009_r + 56 + 8 + 1, 0, !((TileEntityDigitalMiner)this.tileEntity).doPull ? 0 : 8, 15, 8);
        this.func_73729_b(this.field_147003_i + 57, this.field_147009_r + 56, 0, ((TileEntityDigitalMiner)this.tileEntity).silkTouch ? 0 : 8, 15, 8);
        this.func_73729_b(this.field_147003_i + 57, this.field_147009_r + 56 + 8 + 1, 0, !((TileEntityDigitalMiner)this.tileEntity).silkTouch ? 0 : 8, 15, 8);
        this.func_73729_b(this.field_147003_i + 24, this.field_147009_r + 77, 17, 0, 5, 5);
        this.func_73729_b(this.field_147003_i + 43, this.field_147009_r + 77, 24, 0, 5, 5);
        this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 77, 31, 0, 5, 5);
        boolean energy = ((TileEntityDigitalMiner)this.tileEntity).getEnergy() < ((TileEntityDigitalMiner)this.tileEntity).energyUsage || ((TileEntityDigitalMiner)this.tileEntity).getEnergy() == 0.0;
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
                if (((ItemStack)((TileEntityDigitalMiner)this.tileEntity).inventory.get(slotX + slotY * 9)).func_190916_E() != ((ItemStack)((TileEntityDigitalMiner)this.tileEntity).inventory.get(slotX + slotY * 9)).func_77976_d()) continue;
                this.func_73729_b(this.field_147003_i + 7 + slotX * 18, this.field_147009_r + 91 + slotY * 18, 158, 0, 18, 18);
            }
        }
        if (energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }

    protected boolean silkTouchButtoninBounds(int xAxis, int yAxis) {
        return xAxis > 57 && xAxis < 72 && yAxis > 52 && yAxis < 80;
    }

    protected boolean autoEjectButtoninBounds(int xAxis, int yAxis) {
        return xAxis > 19 && xAxis < 34 && yAxis > 52 && yAxis < 80;
    }

    protected boolean autoPullButtoninBounds(int xAxis, int yAxis) {
        return xAxis > 38 && xAxis < 53 && yAxis > 52 && yAxis < 80;
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - this.field_147003_i;
        int yAxis = y - this.field_147009_r;
        if (this.silkTouchButtoninBounds(xAxis, yAxis)) {
            TileNetworkList data = TileNetworkList.withContents(9);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(MekanismSounds.BEEP2);
        } else if (this.autoEjectButtoninBounds(xAxis, yAxis)) {
            TileNetworkList data = TileNetworkList.withContents(0);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(MekanismSounds.BEEP2);
        } else if (this.autoPullButtoninBounds(xAxis, yAxis)) {
            TileNetworkList data = TileNetworkList.withContents(1);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(MekanismSounds.BEEP2);
        }
    }

    private void renderText(String text, float x, float y) {
        int textWidth = this.field_146289_q.func_78256_a(text);
        float centerX = x - (float)textWidth / 2.0f * 0.5f;
        float yAdd = 2.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)(y + yAdd), (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.field_146289_q.func_175065_a(text, centerX, y, 0x101010, false);
        GlStateManager.func_179121_F();
        MekanismRenderer.resetColor();
    }
}

