/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChanceMachine2;
import mekanism.common.recipe.machines.Chance2MachineRecipe;
import mekanism.common.tile.prefab.TileEntityChanceMachine2;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChanceMachine2<RECIPE extends Chance2MachineRecipe<RECIPE>>
extends GuiMekanismTile<TileEntityChanceMachine2<RECIPE>> {
    public GuiChanceMachine2(InventoryPlayer inventory, TileEntityChanceMachine2<RECIPE> tile) {
        super(tile, new ContainerChanceMachine2<RECIPE>(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityChanceMachine2)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityChanceMachine2)this.tileEntity).getMaxEnergy() - ((TileEntityChanceMachine2)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 55, 16));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 55, 52).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, resource, 111, 30));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityChanceMachine2)GuiChanceMachine2.this.tileEntity).getScaledProgress();
            }
        }, GuiProgress.ProgressBar.BAR, this, resource, 77, 37));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean outslot;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Other_Icon.png"));
        this.func_73729_b(this.field_147003_i + 60, this.field_147009_r + 38, 22, 0, 8, 10);
        boolean energy = ((TileEntityChanceMachine2)this.tileEntity).getEnergy() < ((TileEntityChanceMachine2)this.tileEntity).energyPerTick || ((TileEntityChanceMachine2)this.tileEntity).getEnergy() == 0.0;
        boolean bl = outslot = ((ItemStack)((TileEntityChanceMachine2)this.tileEntity).inventory.get(2)).func_190916_E() == ((ItemStack)((TileEntityChanceMachine2)this.tileEntity).inventory.get(2)).func_77976_d();
        if (outslot) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
            this.func_73729_b(this.field_147003_i + 111, this.field_147009_r + 30, 202, 0, 42, 26);
        }
        if (outslot || energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityChanceMachine2)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityChanceMachine2)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean outslot;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityChanceMachine2)this.tileEntity).getEnergy() < ((TileEntityChanceMachine2)this.tileEntity).energyPerTick || ((TileEntityChanceMachine2)this.tileEntity).getEnergy() == 0.0;
            boolean bl = outslot = ((ItemStack)((TileEntityChanceMachine2)this.tileEntity).inventory.get(2)).func_190916_E() == ((ItemStack)((TileEntityChanceMachine2)this.tileEntity).inventory.get(2)).func_77976_d();
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (outslot) {
                info.add(LangUtils.localize("gui.item_no_space"));
            }
            if (energy || outslot) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

