/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBoilerStats
extends GuiMekanismTile<TileEntityBoilerCasing> {
    private final GuiGraph boilGraph;
    private final GuiGraph maxGraph;

    public GuiBoilerStats(InventoryPlayer inventory, TileEntityBoilerCasing tile) {
        super(tile, new ContainerNull(inventory.field_70458_d, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tileEntity, GuiBoilerTab.BoilerTab.MAIN, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityBoilerCasing)this.tileEntity).getLastEnvironmentLoss() * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.boilGraph = new GuiGraph(this, resource, 7, 82, 162, 36, data -> LangUtils.localize("gui.boilRate") + ": " + data + " mB/t");
        this.addGuiElement(this.boilGraph);
        this.maxGraph = new GuiGraph(this, resource, 7, 121, 162, 36, data -> LangUtils.localize("gui.maxBoil") + ": " + data + " mB/t");
        this.addGuiElement(this.maxGraph);
        this.maxGraph.enableFixedScale((int)((double)((TileEntityBoilerCasing)this.tileEntity).getSuperheatingElements() * MekanismConfig.current().general.superheatingHeatTransfer.val() / SynchronizedBoilerData.getHeatEnthalpy()));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String stats = LangUtils.localize("gui.boilerStats");
        this.field_146289_q.func_78276_b(stats, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(stats) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxWater") + ": " + ((TileEntityBoilerCasing)this.tileEntity).clientWaterCapacity + " mB", 8, 26, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxSteam") + ": " + ((TileEntityBoilerCasing)this.tileEntity).clientSteamCapacity + " mB", 8, 35, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.heatTransfer"), 8, 49, 0x797979);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.superheaters") + ": " + ((TileEntityBoilerCasing)this.tileEntity).getSuperheatingElements(), 14, 58, 0x404040);
        int boilCapacity = (int)((double)((TileEntityBoilerCasing)this.tileEntity).getSuperheatingElements() * MekanismConfig.current().general.superheatingHeatTransfer.val() / SynchronizedBoilerData.getHeatEnthalpy());
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.boilCapacity") + ": " + boilCapacity + " mB/t", 8, 72, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.boilGraph.addData(((TileEntityBoilerCasing)this.tileEntity).getLastBoilRate());
        this.maxGraph.addData(((TileEntityBoilerCasing)this.tileEntity).getLastMaxBoil());
    }
}

