/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUtils;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerAdvancedElectricMachine;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAdvancedElectricMachine<RECIPE extends AdvancedMachineRecipe<RECIPE>>
extends GuiMekanismTile<TileEntityAdvancedElectricMachine<RECIPE>> {
    public GuiAdvancedElectricMachine(InventoryPlayer inventory, TileEntityAdvancedElectricMachine<RECIPE> tile) {
        super(tile, new ContainerAdvancedElectricMachine<RECIPE>(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiBar(this, this.getGuiLocation(), 60, 36, 8, 14));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityAdvancedElectricMachine)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityAdvancedElectricMachine)this.tileEntity).getMaxEnergy() - ((TileEntityAdvancedElectricMachine)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 55, 16));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 30, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.EXTRA, this, resource, 55, 52));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, resource, 111, 30));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityAdvancedElectricMachine)GuiAdvancedElectricMachine.this.tileEntity).getScaledProgress();
            }
        }, this.getProgressType(), this, resource, 77, 37));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.BAR;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityAdvancedElectricMachine)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityAdvancedElectricMachine)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean outslot;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityAdvancedElectricMachine)this.tileEntity).getEnergy() < ((TileEntityAdvancedElectricMachine)this.tileEntity).energyPerTick || ((TileEntityAdvancedElectricMachine)this.tileEntity).getEnergy() == 0.0;
            boolean inputgas = ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getStored() == 0 && ((ItemStack)((TileEntityAdvancedElectricMachine)this.tileEntity).inventory.get(0)).func_190916_E() != 0;
            boolean bl = outslot = ((ItemStack)((TileEntityAdvancedElectricMachine)this.tileEntity).inventory.get(2)).func_190916_E() == ((ItemStack)((TileEntityAdvancedElectricMachine)this.tileEntity).inventory.get(2)).func_77976_d();
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (inputgas) {
                info.add(LangUtils.localize("gui.no_gas"));
            }
            if (outslot) {
                info.add(LangUtils.localize("gui.item_no_space"));
            }
            if (inputgas || energy || outslot) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        } else if (xAxis >= 60 && xAxis <= 68 && yAxis >= 36 && yAxis <= 50) {
            this.displayTooltip(((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getGas() != null ? ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getGas().getGas().getLocalizedName() + ": " + (((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getStored() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getStored())) : LangUtils.localize("gui.none"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean outslot;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        GuiUtils.drawGasBarSprite(this.field_147003_i + 60, this.field_147009_r + 36, 8, 14, ((TileEntityAdvancedElectricMachine)this.tileEntity).getScaledGasLevel(12), ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getGas(), true);
        boolean inputgas = ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getStored() == 0 && ((ItemStack)((TileEntityAdvancedElectricMachine)this.tileEntity).inventory.get(0)).func_190916_E() != 0;
        boolean energy = ((TileEntityAdvancedElectricMachine)this.tileEntity).getEnergy() < ((TileEntityAdvancedElectricMachine)this.tileEntity).energyPerTick || ((TileEntityAdvancedElectricMachine)this.tileEntity).getEnergy() == 0.0;
        boolean bl = outslot = ((ItemStack)((TileEntityAdvancedElectricMachine)this.tileEntity).inventory.get(2)).func_190916_E() == ((ItemStack)((TileEntityAdvancedElectricMachine)this.tileEntity).inventory.get(2)).func_77976_d();
        if (outslot) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
            this.func_73729_b(this.field_147003_i + 111, this.field_147009_r + 30, 176, 0, 26, 26);
        }
        if (inputgas) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning_Background.png"));
            this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 37, 0, 0, 6, 12);
        }
        if (outslot || inputgas || energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }
}

