/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.Collections;
import mekanism.client.MekKeyHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemElectricBow;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.item.ItemWalkieTalkie;
import mekanism.common.item.armor.ItemMekAsuitFeetArmour;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.moduleUpgrade;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketJumpBoostData;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.network.PacketStepAssistData;
import mekanism.common.util.LangUtils;
import mekanism.common.util.TextComponentGroup;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MekanismKeyHandler
extends MekKeyHandler {
    public static final String keybindCategory = "Mekanism";
    public static KeyBinding modeSwitchKey = new KeyBinding("mekanism.key.mode", 50, "Mekanism");
    public static KeyBinding armorModeSwitchKey = new KeyBinding("mekanism.key.armorMode", 34, "Mekanism");
    public static KeyBinding freeRunnerModeSwitchKey = new KeyBinding("mekanism.key.feetMode", 48, "Mekanism");
    public static KeyBinding MekAsuitFeetModeSwitchKey = new KeyBinding("mekanism.key.MekAsuitFeetMode", 49, "Mekanism");
    public static KeyBinding voiceKey = new KeyBinding("mekanism.key.voice", 22, "Mekanism");
    public static KeyBinding enableHUDkEY = new KeyBinding("mekanism.key.enableHUD", 35, "Mekanism");
    public static KeyBinding sneakKey = Minecraft.func_71410_x().field_71474_y.field_74311_E;
    public static KeyBinding jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A;
    private static MekKeyHandler.Builder BINDINGS = new MekKeyHandler.Builder().addBinding(modeSwitchKey, false).addBinding(armorModeSwitchKey, false).addBinding(freeRunnerModeSwitchKey, false).addBinding(MekAsuitFeetModeSwitchKey, false).addBinding(voiceKey, true).addBinding(enableHUDkEY, false);

    public MekanismKeyHandler() {
        super(BINDINGS);
        ClientRegistry.registerKeyBinding((KeyBinding)modeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)armorModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)freeRunnerModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)MekAsuitFeetModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)voiceKey);
        ClientRegistry.registerKeyBinding((KeyBinding)enableHUDkEY);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTick(InputEvent event) {
        this.keyTick();
    }

    @Override
    public void keyDown(KeyBinding kb, boolean isRepeat) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (kb == modeSwitchKey) {
            ItemStack toolStack = player.field_71071_by.func_70448_g();
            Item item = toolStack.func_77973_b();
            if (player.func_70093_af() && item instanceof ItemConfigurator) {
                ItemConfigurator configurator = (ItemConfigurator)item;
                ItemConfigurator.ConfiguratorMode configuratorMode = configurator.getState(toolStack);
                int toSet = (configuratorMode.ordinal() + 1) % ItemConfigurator.ConfiguratorMode.values().length;
                configuratorMode = ItemConfigurator.ConfiguratorMode.values()[toSet];
                configurator.setState(toolStack, configuratorMode);
                Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(toSet)));
                player.func_145747_a((ITextComponent)new TextComponentGroup(TextFormatting.GRAY).string("[Mekanism]", TextFormatting.DARK_BLUE).string(" ").translation("mekanism.tooltip.configureState", LangUtils.withColor(configuratorMode.getNameComponent(), configuratorMode.getColor().textFormatting)));
            } else if (player.func_70093_af() && item instanceof ItemElectricBow) {
                ItemElectricBow bow = (ItemElectricBow)item;
                boolean newBowState = !bow.getFireState(toolStack);
                bow.setFireState(toolStack, newBowState);
                Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newBowState)));
                player.func_145747_a((ITextComponent)new TextComponentGroup(TextFormatting.GRAY).string("[Mekanism]", TextFormatting.DARK_BLUE).string(" ").translation("mekanism.tooltip.fireMode", LangUtils.onOffColoured(newBowState)));
            } else if (player.func_70093_af() && item instanceof ItemBlockMachine) {
                ItemBlockMachine machine = (ItemBlockMachine)item;
                if (BlockStateMachine.MachineType.get(toolStack) == BlockStateMachine.MachineType.FLUID_TANK) {
                    boolean newBucketMode = !machine.getBucketMode(toolStack);
                    machine.setBucketMode(toolStack, newBucketMode);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(machine.getBucketMode(toolStack))));
                    player.func_145747_a((ITextComponent)new TextComponentGroup(TextFormatting.GRAY).string("[Mekanism]", TextFormatting.DARK_BLUE).string(" ").translation("mekanism.tooltip.portableTank.bucketMode", LangUtils.onOffColoured(newBucketMode)));
                }
            } else if (player.func_70093_af() && item instanceof ItemWalkieTalkie) {
                ItemWalkieTalkie wt = (ItemWalkieTalkie)item;
                if (wt.getOn(toolStack)) {
                    int newChan = wt.getChannel(toolStack) + 1;
                    if (newChan == 9) {
                        newChan = 1;
                    }
                    wt.setChannel(toolStack, newChan);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newChan)));
                }
            } else if (player.func_70093_af() && item instanceof ItemFlamethrower) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)item;
                flamethrower.incrementMode(toolStack);
                Mekanism.packetHandler.sendToServer(PacketFlamethrowerData.FlamethrowerDataMessage.MODE_CHANGE(EnumHand.MAIN_HAND));
                player.func_145747_a((ITextComponent)new TextComponentGroup(TextFormatting.GRAY).string("[Mekanism]", TextFormatting.DARK_BLUE).string(" ").translation("mekanism.tooltip.flamethrower.modeBump", flamethrower.getMode(toolStack).getTextComponent()));
            }
        } else if (kb == armorModeSwitchKey) {
            ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            Item chestItem = chestStack.func_77973_b();
            if (chestItem instanceof IJetpackItem) {
                IJetpackItem jetpack = (IJetpackItem)chestItem;
                if (player.func_70093_af()) {
                    jetpack.setMode(chestStack, IJetpackItem.JetpackMode.DISABLED);
                } else {
                    jetpack.incrementMode(chestStack);
                }
                Mekanism.packetHandler.sendToServer(PacketJetpackData.JetpackDataMessage.MODE_CHANGE(player.func_70093_af()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            } else if (chestItem instanceof ItemScubaTank) {
                ItemScubaTank scubaTank = (ItemScubaTank)chestItem;
                scubaTank.toggleFlowing(chestStack);
                Mekanism.packetHandler.sendToServer(PacketScubaTankData.ScubaTankDataMessage.MODE_CHANGE(false));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            }
        } else if (kb == freeRunnerModeSwitchKey) {
            ItemStack feetStack = player.func_184582_a(EntityEquipmentSlot.FEET);
            Item item = feetStack.func_77973_b();
            if (item instanceof ItemFreeRunners) {
                ItemFreeRunners freeRunners = (ItemFreeRunners)item;
                if (player.func_70093_af()) {
                    freeRunners.setMode(feetStack, ItemFreeRunners.FreeRunnerMode.DISABLED);
                } else {
                    freeRunners.incrementMode(feetStack);
                }
                Mekanism.packetHandler.sendToServer(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.MODE, null, player.func_70093_af()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            } else {
                item = feetStack.func_77973_b();
                if (item instanceof ItemMekAsuitFeetArmour) {
                    ItemMekAsuitFeetArmour freeArmour = (ItemMekAsuitFeetArmour)item;
                    if (UpgradeHelper.isUpgradeInstalled(feetStack, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) {
                        if (player.func_70093_af()) {
                            freeArmour.setJumpBoostMode(feetStack, ItemMekAsuitFeetArmour.JumpBoost.OFF);
                        } else {
                            freeArmour.incrementJumpBoostMode(feetStack);
                        }
                        Mekanism.packetHandler.sendToServer(new PacketJumpBoostData.JumpBoostDataMessage(PacketJumpBoostData.JumpBoostPacket.MODE, null, player.func_70093_af()));
                        SoundHandler.playSound(MekanismSounds.HYDRAULIC);
                    }
                }
            }
        } else if (kb == MekAsuitFeetModeSwitchKey) {
            ItemStack feetStack = player.func_184582_a(EntityEquipmentSlot.FEET);
            Item item = feetStack.func_77973_b();
            if (item instanceof ItemMekAsuitFeetArmour) {
                ItemMekAsuitFeetArmour freeArmour = (ItemMekAsuitFeetArmour)item;
                if (UpgradeHelper.isUpgradeInstalled(feetStack, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) {
                    if (player.func_70093_af()) {
                        freeArmour.setStepAssistMode(feetStack, ItemMekAsuitFeetArmour.StepAssist.OFF);
                    } else {
                        freeArmour.incrementStepAssistMode(feetStack);
                    }
                    Mekanism.packetHandler.sendToServer(new PacketStepAssistData.StepAssistDataMessage(PacketStepAssistData.StepAssistPacket.MODE, null, player.func_70093_af()));
                    SoundHandler.playSound(MekanismSounds.HYDRAULIC);
                }
            }
        } else if (kb == enableHUDkEY) {
            MekanismConfig.current().client.enableHUD.set(!MekanismConfig.current().client.enableHUD.val());
        }
    }

    @Override
    public void keyUp(KeyBinding kb) {
    }
}

