/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public final class HolidayManager {
    private static Calendar calendar = Calendar.getInstance();
    private static Minecraft mc = Minecraft.func_71410_x();
    private static List<Holiday> holidays = new ArrayList<Holiday>();
    private static List<Holiday> holidaysNotified = new ArrayList<Holiday>();
    public static final Holiday MAY_4 = new May4();
    public static final Holiday APRIL_FOOLS = new AprilFools();

    public static void init() {
        if (MekanismConfig.current().client.holidays.val()) {
            holidays.add(new Christmas());
            holidays.add(new NewYear());
            holidays.add(MAY_4);
            holidays.add(APRIL_FOOLS);
        }
        LocalDate time = LocalDate.now();
        YearlyDate date = new YearlyDate(time.getMonthValue(), time.getDayOfMonth());
        for (Holiday holiday : holidays) {
            holiday.updateIsToday(date);
        }
        Mekanism.logger.info("Initialized HolidayManager.");
    }

    public static void check() {
        try {
            YearlyDate date = HolidayManager.getDate();
            for (Holiday holiday : holidays) {
                if (holidaysNotified.contains(holiday) || !holiday.checkIsToday(date)) continue;
                holiday.onEvent((EntityPlayer)HolidayManager.mc.field_71439_g);
                holidaysNotified.add(holiday);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ResourceLocation filterSound(ResourceLocation sound) {
        if (!MekanismConfig.current().client.holidays.val()) {
            return sound;
        }
        try {
            YearlyDate date = HolidayManager.getDate();
            for (Holiday holiday : holidays) {
                if (!holiday.checkIsToday(date)) continue;
                return holiday.filterSound(sound);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sound;
    }

    private static YearlyDate getDate() {
        return new YearlyDate(calendar.get(2) + 1, calendar.get(5));
    }

    private static String getThemedLines(EnumColor[] colors, int amount) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            builder.append((Object)colors[i % colors.length]).append("-");
        }
        return builder.toString();
    }

    private static class Christmas
    extends Holiday {
        private String[] nutcracker = new String[]{"christmas.1", "christmas.2", "christmas.3", "christmas.4", "christmas.5"};

        private Christmas() {
        }

        @Override
        public YearlyDate getDate() {
            return new YearlyDate(12, 25);
        }

        @Override
        public void onEvent(EntityPlayer player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.DARK_GREEN, EnumColor.DARK_RED}, 13);
            player.func_145747_a((ITextComponent)new TextComponentString(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + themedLines));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.RED) + LangUtils.localize("holiday.mekanism.christmas.1") + " " + (Object)((Object)EnumColor.DARK_BLUE) + player.func_70005_c_() + " " + (Object)((Object)EnumColor.RED) + LangUtils.localize("!")));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.RED) + LangUtils.localize("holiday.mekanism.christmas.2")));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.RED) + LangUtils.localize("holiday.mekanism.christmas.3")));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.RED) + LangUtils.localize("holiday.mekanism.christmas.4")));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_GREY) + "-aidancbrady"));
            player.func_145747_a((ITextComponent)new TextComponentString(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + themedLines));
        }

        @Override
        public ResourceLocation filterSound(ResourceLocation sound) {
            String soundLocation = sound.toString();
            if (soundLocation.contains("machine.enrichment")) {
                return new ResourceLocation(soundLocation.replace("machine.enrichment", this.nutcracker[0]));
            }
            if (soundLocation.contains("machine.metalinfuser")) {
                return new ResourceLocation(soundLocation.replace("machine.metalinfuser", this.nutcracker[1]));
            }
            if (soundLocation.contains("machine.purification")) {
                return new ResourceLocation(soundLocation.replace("machine.purification", this.nutcracker[2]));
            }
            if (soundLocation.contains("machine.smelter")) {
                return new ResourceLocation(soundLocation.replace("machine.smelter", this.nutcracker[3]));
            }
            if (soundLocation.contains("machine.dissolution")) {
                return new ResourceLocation(soundLocation.replace("machine.dissolution", this.nutcracker[4]));
            }
            return sound;
        }
    }

    private static class NewYear
    extends Holiday {
        private NewYear() {
        }

        @Override
        public YearlyDate getDate() {
            return new YearlyDate(1, 1);
        }

        @Override
        public void onEvent(EntityPlayer player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.WHITE, EnumColor.YELLOW}, 13);
            player.func_145747_a((ITextComponent)new TextComponentString(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + themedLines));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.AQUA) + LangUtils.localize("holiday.mekanism.new_year.1") + " " + (Object)((Object)EnumColor.DARK_BLUE) + player.func_70005_c_() + (Object)((Object)EnumColor.RED) + LangUtils.localize("!")));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.AQUA) + LangUtils.localize("holiday.mekanism.new_year.2")));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.AQUA) + LangUtils.localize("holiday.mekanism.new_year.3").replaceAll("%s", String.valueOf(calendar.get(1))) + LangUtils.localize("!") + " :)"));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_GREY) + "-aidancbrady"));
            player.func_145747_a((ITextComponent)new TextComponentString(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + themedLines));
        }
    }

    public static abstract class Holiday {
        private boolean isToday;

        public abstract YearlyDate getDate();

        public abstract void onEvent(EntityPlayer var1);

        public ResourceLocation filterSound(ResourceLocation sound) {
            return sound;
        }

        private void updateIsToday(YearlyDate date) {
            this.isToday = this.checkIsToday(date);
        }

        protected boolean checkIsToday(YearlyDate date) {
            return this.getDate().equals(date);
        }

        public boolean isToday() {
            return this.isToday;
        }
    }

    public static class YearlyDate {
        public Month month;
        public int day;

        public YearlyDate(Month m, int d) {
            this.month = m;
            this.day = d;
        }

        public YearlyDate(int m, int d) {
            this(Month.values()[m - 1], d);
        }

        public boolean equals(Object obj) {
            return obj instanceof YearlyDate && ((YearlyDate)obj).month == this.month && ((YearlyDate)obj).day == this.day;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.month.ordinal();
            code = 31 * code + this.day;
            return code;
        }
    }

    private static class May4
    extends Holiday {
        private May4() {
        }

        @Override
        public YearlyDate getDate() {
            return new YearlyDate(5, 4);
        }

        @Override
        public void onEvent(EntityPlayer player) {
            String themedLines = HolidayManager.getThemedLines(new EnumColor[]{EnumColor.BLACK, EnumColor.GREY, EnumColor.BLACK, EnumColor.YELLOW, EnumColor.BLACK}, 15);
            player.func_145747_a((ITextComponent)new TextComponentString(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + themedLines));
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + LangUtils.localize("holiday.mekanism.may_4.1") + " " + (Object)((Object)EnumColor.DARK_BLUE) + player.func_70005_c_()));
            player.func_145747_a((ITextComponent)new TextComponentString(themedLines + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + themedLines));
        }
    }

    private static class AprilFools
    extends Holiday {
        private AprilFools() {
        }

        @Override
        public YearlyDate getDate() {
            return new YearlyDate(4, 1);
        }

        @Override
        public void onEvent(EntityPlayer player) {
        }
    }

    public static enum Month {
        JANUARY("January"),
        FEBRUARY("February"),
        MARCH("March"),
        APRIL("April"),
        MAY("May"),
        JUNE("June"),
        JULY("July"),
        AUGUST("August"),
        SEPTEMBER("September"),
        OCTOBER("October"),
        NOVEMBER("November"),
        DECEMBER("December");

        private final String name;

        private Month(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }

        public int month() {
            return this.ordinal() + 1;
        }
    }
}

