/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import mekanism.api.IClientTicker;
import mekanism.api.gas.GasStack;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.ItemAtomicDisassembler;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemElectricBow;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemMekTool;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.item.armor.ItemMekAsuitFeetArmour;
import mekanism.common.item.armor.ItemMekAsuitHeadArmour;
import mekanism.common.item.armor.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.moduleUpgrade;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketJumpBoostData;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketStepAssistData;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static Random rand = new Random();
    public static Set<IClientTicker> tickingSet = new ReferenceOpenHashSet();
    public static Map<EntityPlayer, TeleportData> portableTeleports = new Object2ObjectOpenHashMap();
    public static int wheelStatus = 0;
    public boolean initHoliday = false;
    public boolean shouldReset = false;

    public static void killDeadNetworks() {
        tickingSet.removeIf(iClientTicker -> !iClientTicker.needsTicks());
    }

    public static boolean isJetpackInUse(EntityPlayer player, ItemStack jetpack) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isJetpackOn(player);
        }
        if (!player.func_175149_v() && !jetpack.func_190926_b()) {
            boolean rising;
            IJetpackItem.JetpackMode mode = ((IJetpackItem)jetpack.func_77973_b()).getJetpackMode(jetpack);
            boolean guiOpen = ClientTickHandler.mc.field_71462_r != null;
            boolean ascending = ClientTickHandler.mc.field_71439_g.field_71158_b.field_78901_c;
            boolean bl = rising = ascending && !guiOpen;
            if (mode == IJetpackItem.JetpackMode.NORMAL) {
                return rising;
            }
            if (mode == IJetpackItem.JetpackMode.HOVER) {
                boolean descending = ClientTickHandler.mc.field_71439_g.field_71158_b.field_78899_d;
                if (!rising || descending) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGasMaskOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isGasmaskOn(player);
        }
        return CommonPlayerTickHandler.isScubaMaskOn(player, player.func_184582_a(EntityEquipmentSlot.CHEST));
    }

    public static boolean isFreeRunnerOn(EntityPlayer player) {
        Item item;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.freeRunnerOn.contains(player.func_110124_au());
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemFreeRunners) {
            ItemFreeRunners freeRunners = (ItemFreeRunners)item;
            return freeRunners.getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL;
        }
        return false;
    }

    public static boolean isJumpBooston(EntityPlayer player) {
        Item item;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.jumpBoostOn.contains(player.func_110124_au());
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
            ItemMekAsuitFeetArmour feet = (ItemMekAsuitFeetArmour)item;
            return feet.getJumpBoostMode(stack) == ItemMekAsuitFeetArmour.JumpBoost.OFF;
        }
        return false;
    }

    public static boolean isStepAssist(EntityPlayer player) {
        Item item;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.stepAssistOn.contains(player.func_110124_au());
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
            ItemMekAsuitFeetArmour feet = (ItemMekAsuitFeetArmour)item;
            return feet.getStepAssistMode(stack) == ItemMekAsuitFeetArmour.StepAssist.OFF;
        }
        return false;
    }

    public static boolean isFlamethrowerOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isFlamethrowerOn(player);
        }
        return ClientTickHandler.hasFlamethrower(player) && ClientTickHandler.mc.field_71474_y.field_74313_G.func_151470_d();
    }

    public static boolean hasFlamethrower(EntityPlayer player) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (!currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower) {
            return ((ItemFlamethrower)currentItem.func_77973_b()).getGas(currentItem) != null;
        }
        return false;
    }

    public static void portableTeleport(EntityPlayer player, EnumHand hand, Frequency freq) {
        int delay = MekanismConfig.current().general.portableTeleporterDelay.val();
        if (delay == 0) {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, hand, freq));
        } else {
            portableTeleports.put(player, new TeleportData(hand, freq, ClientTickHandler.mc.field_71441_e.func_72820_D() + (long)delay));
        }
    }

    @SubscribeEvent
    public void renderEntityPre(RenderPlayerEvent.Pre evt) {
        ClientTickHandler.setModelVisibility(evt.getEntityPlayer(), evt.getRenderer(), false);
    }

    @SubscribeEvent
    public void renderEntityPost(RenderPlayerEvent.Post evt) {
        ClientTickHandler.setModelVisibility(evt.getEntityPlayer(), evt.getRenderer(), true);
    }

    private static void setModelVisibility(EntityPlayer entity, Render<?> entityModel, boolean showModel) {
        if (entityModel instanceof RenderPlayer) {
            RenderPlayer renderPlayer = (RenderPlayer)entityModel;
            if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemMekaSuitArmor) {
                renderPlayer.func_177087_b().field_78116_c.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178720_f.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_78116_c.field_78807_k = !showModel;
                boolean bl = renderPlayer.func_177087_b().field_178720_f.field_78807_k = !showModel;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemMekaSuitArmor) {
                renderPlayer.func_177087_b().field_178734_a.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178732_b.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178730_v.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178734_a.field_78807_k = !showModel;
                renderPlayer.func_177087_b().field_178732_b.field_78807_k = !showModel;
                boolean bl = renderPlayer.func_177087_b().field_178730_v.field_78807_k = !showModel;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemMekaSuitArmor) {
                renderPlayer.func_177087_b().field_178733_c.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178731_d.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178730_v.field_78806_j = showModel;
                renderPlayer.func_177087_b().field_178733_c.field_78807_k = !showModel;
                renderPlayer.func_177087_b().field_178731_d.field_78807_k = !showModel;
                renderPlayer.func_177087_b().field_178730_v.field_78807_k = !showModel;
            }
        }
    }

    @SubscribeEvent
    public void remove(WorldEvent.Unload event) {
        portableTeleports.remove(ClientTickHandler.mc.field_71439_g);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (!Mekanism.proxy.isPaused()) {
            Iterator<IClientTicker> iter = tickingSet.iterator();
            while (iter.hasNext()) {
                IClientTicker ticker = iter.next();
                if (ticker.needsTicks()) {
                    ticker.clientTick();
                    continue;
                }
                iter.remove();
            }
        }
        if (ClientTickHandler.mc.field_71441_e != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.mc.field_71441_e != null && ClientTickHandler.mc.field_71439_g != null && !Mekanism.proxy.isPaused()) {
            ItemStack primaryJetpack;
            if (!this.initHoliday || MekanismClient.ticksPassed % 1200L == 0L) {
                HolidayManager.check();
                this.initHoliday = true;
            }
            UUID playerUUID = ClientTickHandler.mc.field_71439_g.func_110124_au();
            boolean freeRunnerOn = ClientTickHandler.isFreeRunnerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g);
            if (Mekanism.freeRunnerOn.contains(playerUUID) != freeRunnerOn) {
                if (freeRunnerOn && ClientTickHandler.mc.field_71462_r == null) {
                    Mekanism.freeRunnerOn.add(playerUUID);
                } else {
                    Mekanism.freeRunnerOn.remove(playerUUID);
                }
                Mekanism.packetHandler.sendToServer(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.UPDATE, playerUUID, freeRunnerOn));
            }
            boolean jumpBoostonOn = ClientTickHandler.isJumpBooston((EntityPlayer)ClientTickHandler.mc.field_71439_g);
            if (Mekanism.jumpBoostOn.contains(playerUUID) != jumpBoostonOn) {
                if (jumpBoostonOn && ClientTickHandler.mc.field_71462_r == null) {
                    Mekanism.jumpBoostOn.add(playerUUID);
                } else {
                    Mekanism.jumpBoostOn.remove(playerUUID);
                }
                Mekanism.packetHandler.sendToServer(new PacketJumpBoostData.JumpBoostDataMessage(PacketJumpBoostData.JumpBoostPacket.UPDATE, playerUUID, jumpBoostonOn));
            }
            boolean stepAssistOn = ClientTickHandler.isStepAssist((EntityPlayer)ClientTickHandler.mc.field_71439_g);
            if (Mekanism.stepAssistOn.contains(playerUUID) != stepAssistOn) {
                if (stepAssistOn && ClientTickHandler.mc.field_71462_r == null) {
                    Mekanism.stepAssistOn.add(playerUUID);
                } else {
                    Mekanism.stepAssistOn.remove(playerUUID);
                }
                Mekanism.packetHandler.sendToServer(new PacketStepAssistData.StepAssistDataMessage(PacketStepAssistData.StepAssistPacket.UPDATE, playerUUID, stepAssistOn));
            }
            ClientTickHandler.mc.field_71439_g.field_70138_W = CommonPlayerTickHandler.getStepBoost((EntityPlayer)ClientTickHandler.mc.field_71439_g);
            ItemStack jetpack = IJetpackItem.getActiveJetpack((EntityLivingBase)ClientTickHandler.mc.field_71439_g);
            boolean jetpackInUse = ClientTickHandler.isJetpackInUse((EntityPlayer)ClientTickHandler.mc.field_71439_g, jetpack);
            Mekanism.playerState.setJetpackState(playerUUID, ClientTickHandler.isJetpackInUse((EntityPlayer)ClientTickHandler.mc.field_71439_g, jetpack), true);
            Mekanism.playerState.setGasmaskState(playerUUID, ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Mekanism.playerState.setFlamethrowerState(playerUUID, ClientTickHandler.hasFlamethrower((EntityPlayer)ClientTickHandler.mc.field_71439_g), ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Iterator<Map.Entry<EntityPlayer, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<EntityPlayer, TeleportData> entry = iter.next();
                EntityPlayer player = entry.getKey();
                for (int i = 0; i < 100; ++i) {
                    double x = player.field_70165_t + rand.nextDouble() - 0.5;
                    double y = player.field_70163_u + rand.nextDouble() * 2.0 - 2.0;
                    double z = player.field_70161_v + rand.nextDouble() - 0.5;
                    ClientTickHandler.mc.field_71441_e.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, 0.0, 1.0, 0.0, new int[0]);
                }
                if (ClientTickHandler.mc.field_71441_e.func_72820_D() != entry.getValue().teleportTime) continue;
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!ClientTickHandler.mc.field_71439_g.func_184812_l_() && !ClientTickHandler.mc.field_71439_g.func_175149_v() && ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b();
                flamethrower.useGas(ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g());
            }
            if (!jetpack.func_190926_b() && !(primaryJetpack = IJetpackItem.getPrimaryJetpack((EntityLivingBase)ClientTickHandler.mc.field_71439_g)).func_190926_b()) {
                IJetpackItem.JetpackMode primaryMode = ((IJetpackItem)primaryJetpack.func_77973_b()).getJetpackMode(primaryJetpack);
                IJetpackItem.JetpackMode mode = IJetpackItem.getPlayerJetpackMode((EntityPlayer)ClientTickHandler.mc.field_71439_g, primaryMode, () -> ClientTickHandler.mc.field_71439_g.field_71158_b.field_78901_c);
                MekanismClient.updateKey(ClientTickHandler.mc.field_71439_g.field_71158_b.field_78901_c, KeySync.ASCEND);
                MekanismClient.updateKey(ClientTickHandler.mc.field_71439_g.field_71158_b.field_78899_d, KeySync.DESCEND);
                if (jetpackInUse && IJetpackItem.handleJetpackMotion((EntityPlayer)ClientTickHandler.mc.field_71439_g, mode, () -> ClientTickHandler.mc.field_71439_g.field_71158_b.field_78901_c)) {
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                }
            }
            if (ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemScubaTank tank = (ItemScubaTank)chestStack.func_77973_b();
                int max = 300;
                tank.useGas(chestStack);
                GasStack received = tank.useGas(chestStack, 300 - ClientTickHandler.mc.field_71439_g.func_70086_ai());
                if (received != null) {
                    ClientTickHandler.mc.field_71439_g.func_70050_g(ClientTickHandler.mc.field_71439_g.func_70086_ai() + received.amount);
                }
                if (ClientTickHandler.mc.field_71439_g.func_70086_ai() == 300) {
                    for (PotionEffect effect : ClientTickHandler.mc.field_71439_g.func_70651_bq()) {
                        for (int i = 0; i < 9; ++i) {
                            effect.func_76455_a((EntityLivingBase)ClientTickHandler.mc.field_71439_g);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (ClientTickHandler.mc.field_71439_g != null && ClientTickHandler.mc.field_71439_g.func_70093_af()) {
            Item scaledDelta5;
            Item scaledDelta22;
            Item scaledDelta32;
            Item scaledDelta42;
            int newVal;
            Item item;
            ItemStack stack = ClientTickHandler.mc.field_71439_g.func_184614_ca();
            int delta = Mouse.getEventDWheel();
            if (MekanismConfig.current().client.allowConfiguratorModeScroll.val() && (item = stack.func_77973_b()) instanceof ItemConfigurator) {
                ItemConfigurator configurator = (ItemConfigurator)item;
                if (delta != 0) {
                    RenderTickHandler.modeSwitchTimer = 100;
                    int scaledDelta42 = (wheelStatus += Mouse.getEventDWheel()) / 120;
                    wheelStatus %= 120;
                    newVal = configurator.getState(stack).ordinal() + scaledDelta42 % ItemConfigurator.ConfiguratorMode.values().length;
                    if (newVal > 0) {
                        newVal %= ItemConfigurator.ConfiguratorMode.values().length;
                    } else if (newVal < 0) {
                        newVal = ItemConfigurator.ConfiguratorMode.values().length + newVal;
                    }
                    configurator.setState(stack, ItemConfigurator.ConfiguratorMode.values()[newVal]);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newVal)));
                    event.setCanceled(true);
                }
            }
            if (MekanismConfig.current().client.allowFlamethrowerModeScroll.val() && (scaledDelta42 = stack.func_77973_b()) instanceof ItemFlamethrower) {
                ItemFlamethrower Flamethrower = (ItemFlamethrower)scaledDelta42;
                if (delta != 0) {
                    RenderTickHandler.modeSwitchTimer = 100;
                    int scaledDelta32 = (wheelStatus += Mouse.getEventDWheel()) / 120;
                    wheelStatus %= 120;
                    newVal = Flamethrower.getMode(stack).ordinal() + scaledDelta32 % ItemFlamethrower.FlamethrowerMode.values().length;
                    if (newVal > 0) {
                        newVal %= ItemFlamethrower.FlamethrowerMode.values().length;
                    } else if (newVal < 0) {
                        newVal = ItemFlamethrower.FlamethrowerMode.values().length + newVal;
                    }
                    Flamethrower.setMode(stack, ItemFlamethrower.FlamethrowerMode.values()[newVal]);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newVal)));
                    event.setCanceled(true);
                }
            }
            if (MekanismConfig.current().client.allowAtomicDisassemblerModeScroll.val() && (scaledDelta32 = stack.func_77973_b()) instanceof ItemAtomicDisassembler) {
                ItemAtomicDisassembler AtomicDisassembler = (ItemAtomicDisassembler)scaledDelta32;
                if (delta != 0) {
                    RenderTickHandler.modeSwitchTimer = 100;
                    int scaledDelta22 = (wheelStatus += Mouse.getEventDWheel()) / 120;
                    wheelStatus %= 120;
                    newVal = AtomicDisassembler.getMode(stack).ordinal() + scaledDelta22 % ItemAtomicDisassembler.Mode.values().length;
                    if (newVal > 0) {
                        newVal %= ItemAtomicDisassembler.Mode.values().length;
                    } else if (newVal < 0) {
                        newVal = ItemAtomicDisassembler.Mode.values().length + newVal;
                    }
                    AtomicDisassembler.setMode(stack, ItemAtomicDisassembler.Mode.values()[newVal]);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newVal)));
                    event.setCanceled(true);
                }
            }
            if (MekanismConfig.current().client.allowMekToolModeScroll.val() && (scaledDelta22 = stack.func_77973_b()) instanceof ItemMekTool) {
                ItemMekTool MekTool = (ItemMekTool)scaledDelta22;
                if (delta != 0) {
                    RenderTickHandler.modeSwitchTimer = 100;
                    int scaledDelta5 = (wheelStatus += Mouse.getEventDWheel()) / 120;
                    wheelStatus %= 120;
                    newVal = MekTool.getMode(stack).ordinal() + scaledDelta5 % ItemMekTool.MekToolMode.values().length;
                    if (newVal > 0) {
                        newVal %= ItemMekTool.MekToolMode.values().length;
                    } else if (newVal < 0) {
                        newVal = ItemMekTool.MekToolMode.values().length + newVal;
                    }
                    MekTool.setMode(stack, ItemMekTool.MekToolMode.values()[newVal]);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newVal)));
                    event.setCanceled(true);
                }
            }
            if ((scaledDelta5 = stack.func_77973_b()) instanceof ItemElectricBow) {
                ItemElectricBow Bow = (ItemElectricBow)scaledDelta5;
                if (delta != 0) {
                    RenderTickHandler.modeSwitchTimer = 100;
                    int scaledDelta6 = (wheelStatus += Mouse.getEventDWheel()) / 120;
                    wheelStatus %= 120;
                    if (Math.abs(scaledDelta6) % 2 == 1) {
                        boolean newState = !Bow.getFireState(stack);
                        Bow.setFireState(stack, newState);
                        Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Collections.singletonList(newState)));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void GuiScreenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiGameOver) {
            if (ClientTickHandler.mc.field_71441_e.func_72912_H().func_76093_s()) {
                return;
            }
            if (ClientTickHandler.mc.field_71439_g instanceof EntityPlayerSP) {
                ItemStack head = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!ClientTickHandler.mc.field_71439_g.func_70089_S() && !head.func_190926_b() && head.func_77973_b() instanceof ItemMekAsuitHeadArmour && UpgradeHelper.isUpgradeInstalled(head, moduleUpgrade.EMERGENCY_RESCUE)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private static class TeleportData {
        private EnumHand hand;
        private Frequency freq;
        private long teleportTime;

        public TeleportData(EnumHand h, Frequency f, long t) {
            this.hand = h;
            this.freq = f;
            this.teleportTime = t;
        }
    }
}

