/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import mekanism.api.transmitters.ITransmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.translation.I18n;

public enum TransmissionType {
    ENERGY("EnergyNetwork", "Energy", -11559849, 126, 0),
    FLUID("FluidNetwork", "Fluids", -13474903, 144, 0),
    GAS("GasNetwork", "Gases", -3690678, 162, 0),
    ITEM("InventoryNetwork", "Items", -5723992, 216, 0),
    HEAT("HeatNetwork", "Heat", -3635112, 180, 0);

    private String name;
    private String transmission;
    private int color;
    private int buttonx;
    private int buttony;

    private TransmissionType(String n2, String t, int tabcolor, int buttonx, int buttony) {
        this.name = n2;
        this.transmission = t;
        this.color = tabcolor;
        this.buttonx = buttonx;
        this.buttony = buttony;
    }

    public static boolean checkTransmissionType(ITransmitter sideTile, TransmissionType type) {
        return type.checkTransmissionType(sideTile);
    }

    public static boolean checkTransmissionType(TileEntity tile1, TransmissionType type) {
        return TransmissionType.checkTransmissionType(tile1, type, null);
    }

    public static boolean checkTransmissionType(TileEntity tile1, TransmissionType type, TileEntity tile2) {
        return type.checkTransmissionType(tile1, tile2);
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public String getTransmission() {
        return this.transmission;
    }

    public int getButtonx() {
        return this.buttonx;
    }

    public int getButtony() {
        return this.buttony;
    }

    public String localize() {
        return I18n.func_74838_a((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return "transmission." + this.getTransmission();
    }

    public boolean checkTransmissionType(ITransmitter transmitter) {
        return transmitter.getTransmissionType() == this;
    }

    public boolean checkTransmissionType(TileEntity sideTile, TileEntity currentTile) {
        return sideTile instanceof ITransmitter && ((ITransmitter)sideTile).getTransmissionType() == this;
    }
}

