/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GasTank
implements GasTankInfo {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public volatile GasStack stored;
    private volatile int maxGas;

    private GasTank() {
    }

    public GasTank(int max) {
        this.maxGas = max;
    }

    public static GasTank readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags == null || nbtTags.func_82582_d()) {
            return null;
        }
        GasTank tank = new GasTank();
        tank.read(nbtTags);
        return tank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GasStack draw(int amount, boolean doDraw) {
        if (this.stored == null || amount <= 0) {
            return null;
        }
        try {
            this.rwLock.readLock().lock();
            GasStack ret = new GasStack(this.stored.getGas(), Math.min(this.getStored(), amount));
            if (ret.amount > 0) {
                if (doDraw) {
                    this.stored.amount -= ret.amount;
                    if (this.stored.amount <= 0) {
                        this.stored = null;
                    }
                }
                GasStack gasStack = ret;
                return gasStack;
            }
            GasStack gasStack = null;
            return gasStack;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int receive(GasStack amount, boolean doReceive) {
        if (amount == null || this.stored != null && !this.stored.isGasEqual(amount)) {
            return 0;
        }
        try {
            this.rwLock.readLock().lock();
            int toFill = Math.min(this.maxGas - this.getStored(), amount.amount);
            if (doReceive) {
                if (this.stored == null) {
                    this.stored = amount.copy().withAmount(this.getStored() + toFill);
                } else {
                    this.stored.amount = Math.min(this.maxGas, this.getStored() + amount.amount);
                }
            }
            int n = toFill;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean canReceive(Gas gas) {
        try {
            this.rwLock.readLock().lock();
            boolean bl = this.getNeeded() != 0 && (this.stored == null || gas == null || gas == this.stored.getGas());
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean canReceiveType(Gas gas) {
        try {
            this.rwLock.readLock().lock();
            boolean bl = this.stored == null || gas == null || gas == this.stored.getGas();
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean canDraw(Gas gas) {
        try {
            this.rwLock.readLock().lock();
            boolean bl = this.stored != null && (gas == null || gas == this.stored.getGas());
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getNeeded() {
        return this.maxGas - this.getStored();
    }

    @Override
    public int getMaxGas() {
        return this.maxGas;
    }

    public void setMaxGas(int capacity) {
        this.maxGas = capacity;
    }

    @Override
    public GasStack getGas() {
        try {
            this.rwLock.readLock().lock();
            GasStack gasStack = this.stored;
            return gasStack;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setGas(GasStack stack) {
        try {
            this.rwLock.readLock().lock();
            this.stored = stack;
            if (this.stored != null) {
                this.stored.amount = Math.min(this.maxGas, this.stored.amount);
                if (this.stored.amount <= 0) {
                    this.stored = null;
                }
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Gas getGasType() {
        try {
            this.rwLock.readLock().lock();
            Gas gas = this.stored != null ? this.stored.getGas() : null;
            return gas;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public int getStored() {
        try {
            this.rwLock.readLock().lock();
            int n = this.stored != null ? this.stored.amount : 0;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        if (this.stored != null && this.stored.getGas() != null && this.stored.amount > 0) {
            nbtTags.func_74782_a("stored", (NBTBase)this.stored.write(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("maxGas", this.maxGas);
        return nbtTags;
    }

    public void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("stored")) {
            this.stored = GasStack.readFromNBT(nbtTags.func_74775_l("stored"));
            if (this.stored != null && this.stored.amount <= 0) {
                this.stored = null;
            }
        }
        if (nbtTags.func_74764_b("maxGas") && nbtTags.func_74762_e("maxGas") != 0) {
            this.maxGas = nbtTags.func_74762_e("maxGas");
        }
    }
}

