/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.math.MathUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.translation.I18n;

public enum RelativeSide {
    BOTTOM("sideData.bottom"),
    TOP("sideData.top"),
    FRONT("sideData.front"),
    BACK("sideData.back"),
    LEFT("sideData.left"),
    RIGHT("sideData.right");

    public static final RelativeSide[] SIDES;
    public final String facingname;

    public static RelativeSide bydex(int index) {
        return MathUtils.getByIndexMod(SIDES, index);
    }

    private RelativeSide(String name) {
        this.facingname = name;
    }

    public String getTranslationKey() {
        return I18n.func_74838_a((String)this.facingname);
    }

    public EnumFacing getDirection(EnumFacing facing) {
        EnumFacing enumFacing;
        block0 : switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FRONT: {
                enumFacing = facing;
                break;
            }
            case BACK: {
                enumFacing = facing.func_176734_d();
                break;
            }
            case LEFT: {
                if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                    enumFacing = EnumFacing.EAST;
                    break;
                }
                enumFacing = facing.func_176746_e();
                break;
            }
            case RIGHT: {
                if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                    enumFacing = EnumFacing.WEST;
                    break;
                }
                enumFacing = facing.func_176735_f();
                break;
            }
            case TOP: {
                switch (facing) {
                    case DOWN: {
                        enumFacing = EnumFacing.NORTH;
                        break block0;
                    }
                    case UP: {
                        enumFacing = EnumFacing.SOUTH;
                        break block0;
                    }
                }
                enumFacing = EnumFacing.UP;
                break;
            }
            case BOTTOM: {
                switch (facing) {
                    case DOWN: {
                        enumFacing = EnumFacing.SOUTH;
                        break block0;
                    }
                    case UP: {
                        enumFacing = EnumFacing.NORTH;
                        break block0;
                    }
                }
                enumFacing = EnumFacing.DOWN;
            }
        }
        return enumFacing;
    }

    public static RelativeSide fromDirections(EnumFacing facing, EnumFacing side) {
        if (side == facing) {
            return FRONT;
        }
        if (side == facing.func_176734_d()) {
            return BACK;
        }
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            RelativeSide relativeSide;
            switch (side) {
                case NORTH: {
                    if (facing == EnumFacing.DOWN) {
                        relativeSide = TOP;
                        break;
                    }
                    relativeSide = BOTTOM;
                    break;
                }
                case SOUTH: {
                    if (facing == EnumFacing.DOWN) {
                        relativeSide = BOTTOM;
                        break;
                    }
                    relativeSide = TOP;
                    break;
                }
                case WEST: {
                    relativeSide = RIGHT;
                    break;
                }
                case EAST: {
                    relativeSide = LEFT;
                    break;
                }
                default: {
                    throw new IllegalStateException("Case should have been caught earlier.");
                }
            }
            return relativeSide;
        }
        if (side == EnumFacing.DOWN) {
            return BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return TOP;
        }
        if (side == facing.func_176735_f()) {
            return RIGHT;
        }
        if (side == facing.func_176746_e()) {
            return LEFT;
        }
        return FRONT;
    }

    static {
        SIDES = RelativeSide.values();
    }
}

