/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismRecipeHelper;
import mekanism.api.util.BlockInfo;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class MekanismAPI {
    public static final String API_VERSION = "9.8.1";
    public static boolean debug = false;
    private static Set<BlockInfo> cardboardBoxIgnore = new ObjectOpenHashSet();
    private static Set<String> cardboardBoxModIgnore = new ObjectOpenHashSet();
    private static MekanismRecipeHelper helper = null;

    public static boolean isBlockCompatible(@Nonnull Block block, int meta) {
        if (cardboardBoxModIgnore.contains(Objects.requireNonNull(block.getRegistryName()).func_110624_b())) {
            return false;
        }
        return cardboardBoxIgnore.stream().noneMatch(i -> i.block == block && (i.meta == Short.MAX_VALUE || i.meta == meta));
    }

    public static void addBoxBlacklist(@Nullable Block block, int meta) {
        if (block != null) {
            cardboardBoxIgnore.add(new BlockInfo(block, meta));
        }
    }

    public static void removeBoxBlacklist(@Nonnull Block block, int meta) {
        cardboardBoxIgnore.remove(new BlockInfo(block, meta));
    }

    public static Set<BlockInfo> getBoxIgnore() {
        return cardboardBoxIgnore;
    }

    public static MekanismRecipeHelper recipeHelper() {
        if (helper == null) {
            try {
                helper = (MekanismRecipeHelper)Class.forName("mekanism.common.recipe.APIHandler").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LogManager.getLogger((String)"MekanismAPI").error("Could not find API Handler", (Throwable)e);
            }
        }
        return helper;
    }

    public static void addBoxBlacklistMod(@Nonnull String modid) {
        cardboardBoxModIgnore.add(modid);
    }

    public static void removeBoxBlacklistMod(@Nonnull String modid) {
        cardboardBoxModIgnore.remove(modid);
    }

    public static Set<String> getBoxModIgnore() {
        return cardboardBoxModIgnore;
    }

    public static class BoxBlacklistEvent
    extends Event {
        public void blacklist(@Nonnull ResourceLocation blockLocation, int meta) {
            this.blacklist((Block)ForgeRegistries.BLOCKS.getValue(blockLocation), meta);
        }

        public void blacklist(@Nullable Block block, int meta) {
            MekanismAPI.addBoxBlacklist(block, meta);
        }

        public void blacklistWildcard(@Nonnull ResourceLocation blockLocation) {
            this.blacklistWildcard((Block)ForgeRegistries.BLOCKS.getValue(blockLocation));
        }

        public void blacklistWildcard(@Nullable Block block) {
            MekanismAPI.addBoxBlacklist(block, Short.MAX_VALUE);
        }

        public void blacklistMod(@Nonnull String modid) {
            MekanismAPI.addBoxBlacklistMod(modid);
        }

        public void removeBlacklist(@Nonnull Block block, int meta) {
            MekanismAPI.removeBoxBlacklist(block, meta);
        }

        public void removeWildcardBlacklist(@Nonnull Block block) {
            MekanismAPI.removeBoxBlacklist(block, Short.MAX_VALUE);
        }

        public void removeModBlacklist(@Nonnull String modid) {
            MekanismAPI.removeBoxBlacklistMod(modid);
        }
    }
}

