/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.mixin;

import com.cursery.enchant.CurseEnchantmentHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    private static Map<Enchantment, Integer> previous;

    @Inject(method={"setEnchantments"}, at={@At(value="HEAD")})
    private static void beforeEnchants(Map<Enchantment, Integer> enchants, ItemStack stack, CallbackInfo ci) {
        previous = EnchantmentHelper.m_44831_((ItemStack)stack);
    }

    @Inject(method={"setEnchantments"}, at={@At(value="RETURN")})
    private static void afterEnchanting(Map<Enchantment, Integer> enchants, ItemStack stack, CallbackInfo ci) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return;
        }
        CurseEnchantmentHelper.checkForRandomCurse(stack, previous, EnchantmentHelper.m_44831_((ItemStack)stack));
    }

    @Redirect(method={"selectEnchantment"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getAvailableEnchantmentResults(ILnet/minecraft/world/item/ItemStack;Z)Ljava/util/List;"))
    private static List onGetTableEnchants(int i, ItemStack enchantment, boolean treasures) {
        List enchants = EnchantmentHelper.m_44817_((int)i, (ItemStack)enchantment, (boolean)treasures);
        if (!treasures) {
            enchants.removeIf(e -> e.f_44947_.m_6591_() || e.f_44947_.m_6589_());
        }
        return enchants;
    }
}

