/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.UUID;
import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CrowFluteClearCrowPerchToServer {
    ItemStack flute;
    UUID entityId;
    int hand;

    public CrowFluteClearCrowPerchToServer(ItemStack flute, UUID entityId, int hand) {
        this.flute = flute;
        this.entityId = entityId;
        this.hand = hand;
    }

    public CrowFluteClearCrowPerchToServer(FriendlyByteBuf buf) {
        this.flute = buf.m_130267_();
        this.entityId = buf.m_130259_();
        this.hand = buf.readInt();
    }

    public static void encode(CrowFluteClearCrowPerchToServer object, FriendlyByteBuf buffer) {
        buffer.m_130055_(object.flute);
        buffer.m_130077_(object.entityId);
        buffer.writeInt(object.hand);
    }

    public static CrowFluteClearCrowPerchToServer decode(FriendlyByteBuf buffer) {
        return new CrowFluteClearCrowPerchToServer(buffer);
    }

    public static void consume(CrowFluteClearCrowPerchToServer packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            block7: {
                Level world;
                block6: {
                    if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                        world = Hexerei.proxy.getLevel();
                    } else {
                        if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                            return;
                        }
                        world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
                    }
                    if (packet.hand != 0) break block6;
                    if (world.m_46003_(packet.entityId).m_21205_().m_41720_() != packet.flute.m_41720_()) break block7;
                    ListTag list = world.m_46003_(packet.entityId).m_21205_().m_41784_().m_128437_("crowList", 10);
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag compoundTag = list.m_128728_(i);
                        Entity entity = ((ServerLevel)world).m_8791_(compoundTag.m_128342_("UUID"));
                        if (!(entity instanceof CrowEntity)) continue;
                        ((CrowEntity)entity).setPerchPos(null);
                    }
                    break block7;
                }
                if (world.m_46003_(packet.entityId).m_21206_().m_41720_() == packet.flute.m_41720_()) {
                    ListTag list = world.m_46003_(packet.entityId).m_21206_().m_41784_().m_128437_("crowList", 10);
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag compoundTag = list.m_128728_(i);
                        Entity entity = ((ServerLevel)world).m_8791_(compoundTag.m_128342_("UUID"));
                        if (!(entity instanceof CrowEntity)) continue;
                        ((CrowEntity)entity).setPerchPos(null);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

