/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookPage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BookPagesPacket {
    protected final Map<ResourceLocation, BookPage> bookPages;

    public BookPagesPacket(Map<ResourceLocation, BookPage> bookPages) {
        this.bookPages = bookPages;
    }

    public BookPagesPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.bookPages = new HashMap<ResourceLocation, BookPage>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation name = buf.m_130281_();
            CompoundTag tag = buf.m_130260_();
            if (tag == null) continue;
            BookPage bookPage = BookPage.loadFromTag(tag);
            this.bookPages.put(name, bookPage);
        }
    }

    public static void encode(BookPagesPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.bookPages.size());
        for (Map.Entry<ResourceLocation, BookPage> entry : object.bookPages.entrySet()) {
            buffer.m_130085_(entry.getKey());
            buffer.m_130079_(BookPage.saveToTag(entry.getValue()));
        }
    }

    public static BookPagesPacket decode(FriendlyByteBuf buffer) {
        return new BookPagesPacket(buffer);
    }

    public static void consume(BookPagesPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Level world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            }
            BookManager.clearBookPages();
            packet.bookPages.keySet().forEach(k -> {
                BookPage bookPage = packet.bookPages.get(k);
                BookManager.addBookPage(k, bookPage);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

