/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BookEntriesPacket {
    protected BookEntries bookEntries;

    public BookEntriesPacket(BookEntries bookEntries) {
        this.bookEntries = bookEntries;
    }

    public BookEntriesPacket(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        if (tag != null) {
            this.bookEntries = BookEntries.loadFromTag(tag);
        }
    }

    public static void encode(BookEntriesPacket object, FriendlyByteBuf buffer) {
        buffer.m_130079_(BookEntries.saveToTag(object.bookEntries));
    }

    public static BookEntriesPacket decode(FriendlyByteBuf buffer) {
        return new BookEntriesPacket(buffer);
    }

    public static void consume(BookEntriesPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Level world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            }
            BookManager.clearBookEntries();
            BookManager.addBookEntries(packet.bookEntries);
        });
        ctx.get().setPacketHandled(true);
    }
}

