/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen.renderer;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class FluidStackRenderer
implements IIngredientRenderer<FluidStack> {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    public final int capacityMb;
    private final TooltipMode tooltipMode;
    @Deprecated
    @Nullable
    private final IDrawable overlay;
    private final int width;
    private final int height;

    public FluidStackRenderer() {
        this(1000, TooltipMode.ITEM_LIST, 16, 16, null);
    }

    public FluidStackRenderer(int capacityMb, boolean showCapacity, int width, int height) {
        this(capacityMb, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height, null);
    }

    @Deprecated
    public FluidStackRenderer(int capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay) {
        this(capacityMb, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height, overlay);
    }

    private FluidStackRenderer(int capacityMb, TooltipMode tooltipMode, int width, int height, @Nullable IDrawable overlay) {
        Preconditions.checkArgument((capacityMb > 0 ? 1 : 0) != 0, (Object)"capacity must be > 0");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        this.capacityMb = capacityMb;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    public void render(PoseStack poseStack, FluidStack fluidStack) {
        RenderSystem.m_69478_();
        this.drawFluid(poseStack, this.width, this.height, fluidStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.overlay != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 200.0);
            this.overlay.draw(poseStack);
            poseStack.m_85849_();
        }
        RenderSystem.m_69461_();
    }

    public void render(PoseStack stack, int xPosition, int yPosition, @Nullable FluidStack ingredient) {
        if (ingredient != null) {
            stack.m_85836_();
            stack.m_85837_((double)xPosition, (double)yPosition, 0.0);
            this.render(stack, ingredient);
            stack.m_85849_();
        }
    }

    private void drawFluid(PoseStack poseStack, int width, int height, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = FluidStackRenderer.getStillFluidSprite(fluidStack);
        FluidType attributes = fluid.getFluidType();
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        int amount = fluidStack.getAmount();
        int scaledAmount = amount * height / this.capacityMb;
        if (amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        FluidStackRenderer.drawTiledSprite(poseStack, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private static void drawTiledSprite(PoseStack poseStack, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        FluidStackRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidStackRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Fluid fluid = fluidStack.getFluid();
        FluidType attributes = fluid.getFluidType();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMin += (float)maskRight / 16.0f * (uMax - uMin);
        vMin += (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public List<Component> getTooltip(FluidStack fluidStack, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluidType = fluidStack.getFluid();
        if (fluidType == null) {
            return tooltip;
        }
        Component displayName = fluidStack.getDisplayName();
        if (fluidStack.isEmpty()) {
            displayName = Component.m_237115_((String)"book.hexerei.tooltip.empty");
        }
        tooltip.add(displayName);
        int amount = fluidStack.getAmount();
        if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
            MutableComponent amountString = Component.m_237110_((String)"book.hexerei.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{nf.format(amount), nf.format(this.capacityMb)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
            MutableComponent amountString = Component.m_237110_((String)"book.hexerei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(amount)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

