/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BloodBitParticle
extends TextureSheetParticle {
    private final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/particle/cauldron_boil_particle.png");
    public static final Vec3[] CUBE = new Vec3[]{new Vec3(0.1, -0.01, -0.1), new Vec3(0.1, -0.01, 0.1), new Vec3(-0.1, -0.01, 0.1), new Vec3(-0.1, -0.01, -0.1), new Vec3(-0.1, 0.01, -0.1), new Vec3(-0.1, 0.01, 0.1), new Vec3(0.1, 0.01, 0.1), new Vec3(0.1, 0.01, -0.1)};
    public static final Vec3[] CUBE_NORMALS = new Vec3[]{new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.5)};
    private static final ParticleRenderType renderType = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    };
    protected float scale;
    protected float rotationDirection;
    protected float rotation;
    protected float rotationOffsetYaw;
    protected float rotationOffsetPitch;
    protected float rotationOffsetRoll;
    protected float colorOffset;

    public BloodBitParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.rotation = 0.0f;
        this.averageAge(80);
        Random random = new Random();
        this.colorOffset = random.nextFloat() * 0.25f;
        this.rotationOffsetYaw = random.nextFloat();
        this.rotationOffsetPitch = random.nextFloat();
        this.rotationOffsetRoll = random.nextFloat();
        this.setScale(0.2f);
        this.setRotationDirection(random.nextFloat() - 0.5f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.m_107250_(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        Random random = new Random();
        this.f_107225_ = (int)((double)age + (random.nextDouble() * 2.0 - 1.0) * 8.0);
    }

    public void setRotationDirection(float rotationDirection) {
        this.rotationDirection = rotationDirection;
    }

    public void m_5989_() {
        this.rotation = this.rotationDirection * 0.1f + this.rotation;
        super.m_5989_();
    }

    public void m_5744_(VertexConsumer builder, Camera renderInfo, float p_225606_3_) {
        Vec3 projectedView = renderInfo.m_90583_();
        float lerpX = (float)(Mth.m_14139_((double)p_225606_3_, (double)this.f_107209_, (double)this.f_107212_) - projectedView.m_7096_());
        float lerpY = (float)(Mth.m_14139_((double)p_225606_3_, (double)this.f_107210_, (double)this.f_107213_) - projectedView.m_7098_());
        float lerpZ = (float)(Mth.m_14139_((double)p_225606_3_, (double)this.f_107211_, (double)this.f_107214_) - projectedView.m_7094_());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(Mth.m_14036_((float)((float)this.f_107224_ + p_225606_3_), (float)0.0f, (float)this.f_107225_), 3.0) / Math.pow(this.f_107225_, 3.0);
        RenderSystem.m_157179_((int)0, (ResourceLocation)this.TEXTURE);
        for (int i = 0; i < CUBE.length / 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vec3 vec = CUBE[i * 4 + j];
                vec = vec.m_82524_(this.rotation + this.rotationOffsetYaw).m_82496_(this.rotation + this.rotationOffsetPitch).m_82535_(this.rotation + this.rotationOffsetRoll).m_82490_((double)this.scale * ageMultiplier).m_82520_((double)lerpX, (double)lerpY, (double)lerpZ);
                Vec3 normal = CUBE_NORMALS[i];
                builder.m_5483_(vec.f_82479_, vec.f_82480_, vec.f_82481_).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 0.8f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 0.8f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 0.8f), (float)0.0f, (float)1.0f), this.f_107230_).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(light).m_5752_();
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BloodBitParticle cauldronParticle = new BloodBitParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            Random random = new Random();
            float colorOffset = random.nextFloat() * 0.1f;
            cauldronParticle.m_107253_(0.025f + colorOffset, 0.05f, 0.05f);
            cauldronParticle.m_107271_(1.0f);
            cauldronParticle.m_108335_(this.spriteSet);
            return cauldronParticle;
        }
    }
}

