/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.data.recipes.MoonPhases;
import net.joefoxe.hexerei.fluid.FluidIngredient;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class MixingCauldronRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final FluidStack liquid;
    private final FluidStack liquidOutput;
    private final int fluidLevelsConsumed;
    protected static final List<Boolean> itemMatchesSlot = new ArrayList<Boolean>();
    private final FluidMixingRecipe.HeatCondition heatCondition;
    private final MoonPhases.MoonCondition moonCondition;

    public boolean m_5598_() {
        return true;
    }

    public MixingCauldronRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, FluidStack liquid, FluidStack liquidOutput, int fluidLevelsConsumed) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.liquid = liquid;
        this.liquidOutput = liquidOutput;
        this.fluidLevelsConsumed = fluidLevelsConsumed;
        this.heatCondition = FluidMixingRecipe.HeatCondition.NONE;
        this.moonCondition = MoonPhases.MoonCondition.NONE;
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public MixingCauldronRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, FluidStack liquid, FluidStack liquidOutput, int fluidLevelsConsumed, FluidMixingRecipe.HeatCondition heatCondition, MoonPhases.MoonCondition moonCondition) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.liquid = liquid;
        this.liquidOutput = liquidOutput;
        this.fluidLevelsConsumed = fluidLevelsConsumed;
        this.heatCondition = heatCondition;
        this.moonCondition = moonCondition;
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public List<FluidIngredient> getFluidIngredients() {
        return new ArrayList<FluidIngredient>(List.of(FluidIngredient.fromFluidStack(this.liquid)));
    }

    public FluidIngredient getFluidIngredient() {
        return FluidIngredient.fromFluidStack(this.liquid);
    }

    public boolean matches(SimpleContainer inv, Level worldIn) {
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.set(i, false);
        }
        boolean flag = false;
        for (Ingredient recipeItem : this.recipeItems) {
            for (int i = 0; i < 8; ++i) {
                if (!recipeItem.test(inv.m_8020_(i)) || itemMatchesSlot.get(i).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int i = 0; i < 8; ++i) {
            if (itemMatchesSlot.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer p_44001_) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public FluidMixingRecipe.HeatCondition getHeatCondition() {
        return this.heatCondition;
    }

    public MoonPhases.MoonCondition getMoonCondition() {
        return this.moonCondition;
    }

    public FluidStack getLiquid() {
        return this.liquid;
    }

    public FluidStack getLiquidOutput() {
        return this.liquidOutput;
    }

    public int getFluidLevelsConsumed() {
        return this.fluidLevelsConsumed;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.MIXING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<MixingCauldronRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<MixingCauldronRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public MixingCauldronRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            FluidStack liquid = Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"liquid"));
            FluidStack liquidOutput = Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"liquidOutput"));
            int fluidLevelsConsumed = GsonHelper.m_13927_((JsonObject)json, (String)"fluidLevelsConsumed");
            String heatRequirement = GsonHelper.m_13851_((JsonObject)json, (String)"heatRequirement", (String)"none");
            FluidMixingRecipe.HeatCondition heatCondition = FluidMixingRecipe.HeatCondition.getHeated(heatRequirement);
            String moonRequirement = GsonHelper.m_13851_((JsonObject)json, (String)"moonRequirement", (String)"none");
            MoonPhases.MoonCondition moonCondition = MoonPhases.MoonCondition.getMoonCondition(moonRequirement);
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)8, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new MixingCauldronRecipe(recipeId, output, (NonNullList<Ingredient>)inputs, liquid, liquidOutput, fluidLevelsConsumed, heatCondition, moonCondition);
        }

        @Nullable
        public MixingCauldronRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new MixingCauldronRecipe(recipeId, buffer.m_130267_(), (NonNullList<Ingredient>)inputs, buffer.readFluidStack(), buffer.readFluidStack(), buffer.readInt(), (FluidMixingRecipe.HeatCondition)buffer.m_130066_(FluidMixingRecipe.HeatCondition.class), (MoonPhases.MoonCondition)buffer.m_130066_(MoonPhases.MoonCondition.class));
        }

        public void toNetwork(FriendlyByteBuf buffer, MixingCauldronRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeFluidStack(recipe.getLiquid());
            buffer.writeFluidStack(recipe.getLiquidOutput());
            buffer.writeInt(recipe.getFluidLevelsConsumed());
            buffer.m_130068_((Enum)recipe.getHeatCondition());
            buffer.m_130068_((Enum)recipe.getMoonCondition());
        }

        public static FluidStack deserializeFluidStack(JsonObject json) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + id + "'");
            }
            FluidStack stack = new FluidStack(fluid, 1);
            if (!json.has("nbt")) {
                return stack;
            }
            try {
                JsonElement element = json.get("nbt");
                stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? Hexerei.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return stack;
        }
    }
}

