/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookImage;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookNonItemTooltip;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookParagraph;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BookReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public BookReloadListener() {
        super(GSON, "book");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        BookManager.clearBookPages();
        jsons.forEach((key, input) -> {
            if (input != null) {
                try {
                    String keyString = key.m_135815_();
                    if (!keyString.equals("book_entries")) {
                        BookReloadListener.addBookPage(key, input);
                    } else {
                        BookReloadListener.addBookEntries(key, input);
                    }
                }
                catch (Exception e) {
                    Hexerei.LOGGER.error("Failed to parse JSON object for book page " + key);
                }
            }
        });
        if (EffectiveSide.get().isServer() && ServerLifecycleHooks.getCurrentServer() != null) {
            BookManager.sendBookEntriesToClient();
            BookManager.sendBookPagesToClient();
        }
    }

    private static void addBookPage(ResourceLocation key, JsonElement input) throws CommandSyntaxException {
        JsonObject jsonObject = input.getAsJsonObject();
        String title = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"showTitle", (String)"none");
        ArrayList<BookParagraph> paragraphsList = new ArrayList<BookParagraph>();
        if (jsonObject.has("paragraphs")) {
            JsonArray paragraphs = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"paragraphs");
            for (int i = 0; i < paragraphs.size(); ++i) {
                JsonObject obj = paragraphs.get(i).getAsJsonObject();
                paragraphsList.add(BookParagraph.deserialize(obj));
            }
        }
        ArrayList<BookItemsAndFluids> itemsInSlotsList = new ArrayList<BookItemsAndFluids>();
        if (jsonObject.has("items_and_fluids")) {
            JsonArray itemsAndFluids = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"items_and_fluids");
            for (int i = 0; i < itemsAndFluids.size(); ++i) {
                JsonObject obj = itemsAndFluids.get(i).getAsJsonObject();
                itemsInSlotsList.add(BookItemsAndFluids.deserialize(obj));
            }
        }
        ArrayList<BookEntity> entityList = new ArrayList<BookEntity>();
        if (jsonObject.has("entities")) {
            JsonArray entity = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"entities");
            for (int i = 0; i < entity.size(); ++i) {
                JsonObject obj = entity.get(i).getAsJsonObject();
                entityList.add(BookEntity.deserialize(obj));
            }
        }
        ArrayList<BookImage> imagesList = new ArrayList<BookImage>();
        if (jsonObject.has("images")) {
            JsonArray images = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"images");
            for (int i = 0; i < images.size(); ++i) {
                JsonObject obj = images.get(i).getAsJsonObject();
                imagesList.add(BookImage.deserialize(obj));
            }
        }
        ArrayList<BookNonItemTooltip> nonItemTooltipsList = new ArrayList<BookNonItemTooltip>();
        if (jsonObject.has("non_item_tooltips")) {
            JsonArray non_item_tooltips = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"non_item_tooltips");
            for (int i = 0; i < non_item_tooltips.size(); ++i) {
                JsonObject obj = non_item_tooltips.get(i).getAsJsonObject();
                nonItemTooltipsList.add(BookNonItemTooltip.deserialize(obj));
            }
        }
        String itemHyperlink = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"item_hyperlink", (String)"none");
        BookManager.addBookPage(key, new BookPage(title, paragraphsList, itemsInSlotsList, entityList, imagesList, nonItemTooltipsList, itemHyperlink));
    }

    private static void addBookEntries(ResourceLocation key, JsonElement input) {
        JsonObject jsonObject = input.getAsJsonObject();
        int numberOfPages = 0;
        ArrayList<BookChapter> chaptersList = new ArrayList<BookChapter>();
        if (jsonObject.has("chapters")) {
            JsonArray chapters = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"chapters");
            for (int i = 0; i < chapters.size(); ++i) {
                JsonObject obj = chapters.get(i).getAsJsonObject();
                BookChapter bookChapter = BookChapter.deserialize(obj, numberOfPages);
                numberOfPages += bookChapter.pages.size();
                chaptersList.add(bookChapter);
            }
        }
        BookManager.addBookEntries(new BookEntries(chaptersList, numberOfPages));
    }
}

