/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import java.util.Arrays;
import java.util.function.Supplier;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class ModChestBoatEntity
extends ChestBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(ModChestBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModChestBoatEntity(EntityType<ModChestBoatEntity> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.WILLOW.ordinal());
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.m_38369_());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("model", this.getModel().getName());
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128425_("model", 8)) {
            this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)Type.byName(nbt.m_128461_("model")).ordinal());
        }
    }

    public void setType(Type pBoatType) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)pBoatType.ordinal());
    }

    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    public Type getModBoatType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    public Item m_38369_() {
        return switch (Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE))) {
            default -> (Item)ModItems.WILLOW_CHEST_BOAT.get();
            case Type.POLISHED_WILLOW -> (Item)ModItems.POLISHED_WILLOW_CHEST_BOAT.get();
            case Type.MAHOGANY -> (Item)ModItems.MAHOGANY_CHEST_BOAT.get();
            case Type.POLISHED_MAHOGANY -> (Item)ModItems.POLISHED_MAHOGANY_CHEST_BOAT.get();
        };
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_142687_(Entity.RemovalReason.KILLED);
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public ModChestBoatEntity withModel(Type type) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)type.ordinal());
        return this;
    }

    public Type getModel() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    public static enum Type {
        WILLOW("willow", (Supplier<Block>)ModBlocks.WILLOW_PLANKS),
        POLISHED_WILLOW("polished_willow", (Supplier<Block>)ModBlocks.POLISHED_WILLOW_PLANKS),
        MAHOGANY("mahogany", (Supplier<Block>)ModBlocks.MAHOGANY_PLANKS),
        POLISHED_MAHOGANY("polished_mahogany", (Supplier<Block>)ModBlocks.POLISHED_MAHOGANY_PLANKS);

        private final String name;
        private final Supplier<Block> supplierPlanks;

        private Type(String name, Supplier<Block> supplierPlanks) {
            this.name = name;
            this.supplierPlanks = supplierPlanks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.supplierPlanks.get();
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] type = Type.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static Type byName(String aName) {
            Type[] type = Type.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }
    }
}

