/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.compat.requiem.CCRequiem;
import net.tigereye.chestcavity.interfaces.CCOrganItem;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.OrganAddStatusEffectListeners;
import net.tigereye.chestcavity.listeners.OrganOnHitContext;
import net.tigereye.chestcavity.listeners.OrganOnHitListener;
import net.tigereye.chestcavity.listeners.OrganTickListeners;
import net.tigereye.chestcavity.listeners.OrganUpdateListeners;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTagOrgans;
import net.tigereye.chestcavity.util.NetworkUtil;
import net.tigereye.chestcavity.util.OrganUtil;

public class ChestCavityUtil {
    public static void addOrganScore(ResourceLocation id, float value, Map<ResourceLocation, Float> organScores) {
        organScores.put(id, Float.valueOf(organScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue() + value));
    }

    public static float applyBoneDefense(ChestCavityInstance cc, float damage) {
        float boneDiff = (cc.getOrganScore(CCOrganScores.DEFENSE) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.DEFENSE)) / 4.0f;
        return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.BONE_DEFENSE, boneDiff));
    }

    public static int applyBreathInWater(ChestCavityInstance cc, int oldAir, int newAir) {
        if (!cc.opened || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_CAPACITY) == cc.getOrganScore(CCOrganScores.BREATH_CAPACITY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.WATERBREATH) == cc.getOrganScore(CCOrganScores.WATERBREATH)) {
            return newAir;
        }
        float airLoss = 1.0f;
        float waterBreath = cc.getOrganScore(CCOrganScores.WATERBREATH);
        if (cc.owner.m_20142_()) {
            waterBreath /= 4.0f;
        }
        if (waterBreath > 0.0f) {
            airLoss += -2.0f * waterBreath;
        }
        if (airLoss > 0.0f) {
            if (oldAir == newAir) {
                airLoss = 0.0f;
            } else {
                float capacity = cc.getOrganScore(CCOrganScores.BREATH_CAPACITY);
                if ((airLoss *= (float)(oldAir - newAir)) > 0.0f) {
                    float lungRatio = 20.0f;
                    if (capacity != 0.0f) {
                        lungRatio = Math.min(2.0f / capacity, 20.0f);
                    }
                    airLoss = airLoss * lungRatio + cc.lungRemainder;
                }
            }
        }
        cc.lungRemainder = airLoss % 1.0f;
        int airResult = Math.min(oldAir - (int)airLoss, cc.owner.m_6062_());
        if (airResult <= -20) {
            airResult = 0;
            cc.lungRemainder = 0.0f;
            cc.owner.m_6469_(DamageSource.f_19312_, 2.0f);
        }
        return airResult;
    }

    public static int applyBreathOnLand(ChestCavityInstance cc, int oldAir, int airGain) {
        int airResult;
        if (!cc.opened || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_RECOVERY) == cc.getOrganScore(CCOrganScores.BREATH_RECOVERY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_CAPACITY) == cc.getOrganScore(CCOrganScores.BREATH_CAPACITY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.WATERBREATH) == cc.getOrganScore(CCOrganScores.WATERBREATH)) {
            return oldAir;
        }
        float airLoss = !cc.owner.m_21023_(MobEffects.f_19608_) && !cc.owner.m_21023_(MobEffects.f_19592_) ? 1.0f : 0.0f;
        float breath = cc.getOrganScore(CCOrganScores.BREATH_RECOVERY);
        if (cc.owner.m_20142_()) {
            breath /= 4.0f;
        }
        if (cc.owner.m_20070_()) {
            breath += cc.getOrganScore(CCOrganScores.WATERBREATH) / 4.0f;
        }
        if (breath > 0.0f) {
            airLoss += (float)(-airGain) * breath / 2.0f;
        }
        if (airLoss > 0.0f) {
            airResult = EnchantmentHelper.m_44918_((LivingEntity)cc.owner);
            if (cc.owner.m_217043_().m_188503_(airResult + 1) != 0) {
                airLoss = 0.0f;
            } else {
                float capacity = cc.getOrganScore(CCOrganScores.BREATH_CAPACITY);
                float breathRatio = 20.0f;
                if (capacity != 0.0f) {
                    breathRatio = Math.min(2.0f / capacity, 20.0f);
                }
                airLoss = airLoss * breathRatio + cc.lungRemainder;
            }
        } else if (oldAir == cc.owner.m_6062_()) {
            return oldAir;
        }
        cc.lungRemainder = airLoss % 1.0f;
        airResult = Math.min(oldAir - (int)airLoss - airGain, cc.owner.m_6062_());
        if (airResult <= -20) {
            airResult = 0;
            cc.lungRemainder = 0.0f;
            cc.owner.m_6469_(DamageSource.f_19312_, 2.0f);
        }
        return airResult;
    }

    public static float applyDefenses(ChestCavityInstance cc, DamageSource source, float damage) {
        if (!cc.opened) {
            return damage;
        }
        if (ChestCavityUtil.attemptArrowDodging(cc, source)) {
            return 0.0f;
        }
        if (!source.m_19376_()) {
            damage = ChestCavityUtil.applyBoneDefense(cc, damage);
        }
        if (source == DamageSource.f_19315_) {
            damage = ChestCavityUtil.applyLeapingToFallDamage(cc, damage);
        }
        if (source == DamageSource.f_19315_ || source == DamageSource.f_19316_) {
            damage = ChestCavityUtil.applyImpactResistant(cc, damage);
        }
        if (source.m_19384_()) {
            damage = ChestCavityUtil.applyFireResistant(cc, damage);
        }
        return damage;
    }

    public static int applyDigestion(ChestCavityInstance cc, float digestion, int hunger) {
        if (digestion == 1.0f) {
            return hunger;
        }
        if (digestion < 0.0f) {
            cc.owner.m_7292_(new MobEffectInstance(MobEffects.f_19604_, (int)((float)(-hunger) * digestion * 400.0f)));
            return 0;
        }
        return Math.max((int)((float)hunger * digestion), 1);
    }

    public static float applyFireResistant(ChestCavityInstance cc, float damage) {
        float fireproof = cc.getOrganScore(CCOrganScores.FIRE_RESISTANT);
        return fireproof > 0.0f ? (float)((double)damage * Math.pow(1.0f - ChestCavity.config.FIREPROOF_DEFENSE, fireproof / 4.0f)) : damage;
    }

    public static float applyImpactResistant(ChestCavityInstance cc, float damage) {
        float impactResistant = cc.getOrganScore(CCOrganScores.IMPACT_RESISTANT);
        return impactResistant > 0.0f ? (float)((double)damage * Math.pow(1.0f - ChestCavity.config.IMPACT_DEFENSE, impactResistant / 4.0f)) : damage;
    }

    public static Float applyLeaping(ChestCavityInstance cc, float velocity) {
        float leaping = cc.getOrganScore(CCOrganScores.LEAPING);
        float defaultLeaping = cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LEAPING);
        return Float.valueOf(velocity * Math.max(0.0f, 1.0f + (leaping - defaultLeaping) * 0.25f));
    }

    public static float applyLeapingToFallDamage(ChestCavityInstance cc, float damage) {
        float leapingDiff = cc.getOrganScore(CCOrganScores.LEAPING) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LEAPING);
        return leapingDiff > 0.0f ? Math.max(0.0f, damage - leapingDiff * leapingDiff / 4.0f) : damage;
    }

    public static float applyNutrition(ChestCavityInstance cc, float nutrition, float saturation) {
        if (nutrition == 4.0f) {
            return saturation;
        }
        if (nutrition < 0.0f) {
            cc.owner.m_7292_(new MobEffectInstance(MobEffects.f_19612_, (int)(saturation * nutrition * 800.0f)));
            return 0.0f;
        }
        return saturation * nutrition / 4.0f;
    }

    public static float applyNervesToMining(ChestCavityInstance cc, float miningProgress) {
        float defaultNerves = cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.NERVES);
        if (defaultNerves == 0.0f) {
            return miningProgress;
        }
        float NervesDiff = cc.getOrganScore(CCOrganScores.NERVES) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.NERVES);
        return miningProgress * (1.0f + ChestCavity.config.NERVES_HASTE * NervesDiff);
    }

    public static int applySpleenMetabolism(ChestCavityInstance cc, int foodStarvationTimer) {
        if (!cc.opened) {
            return foodStarvationTimer;
        }
        float metabolismDiff = cc.getOrganScore(CCOrganScores.METABOLISM) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.METABOLISM);
        if (metabolismDiff == 0.0f) {
            return foodStarvationTimer;
        }
        if (metabolismDiff > 0.0f) {
            cc.metabolismRemainder += metabolismDiff;
            foodStarvationTimer += (int)cc.metabolismRemainder;
        } else {
            cc.metabolismRemainder += 1.0f - 1.0f / (-metabolismDiff + 1.0f);
            foodStarvationTimer -= (int)cc.metabolismRemainder;
        }
        cc.metabolismRemainder %= 1.0f;
        return foodStarvationTimer;
    }

    public static float applySwimSpeedInWater(ChestCavityInstance cc) {
        if (cc.opened && cc.owner.m_20069_()) {
            float speedDiff = cc.getOrganScore(CCOrganScores.SWIM_SPEED) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.SWIM_SPEED);
            return speedDiff == 0.0f ? 1.0f : Math.max(0.0f, 1.0f + speedDiff * ChestCavity.config.SWIMSPEED_FACTOR / 8.0f);
        }
        return 1.0f;
    }

    public static boolean attemptArrowDodging(ChestCavityInstance cc, DamageSource source) {
        float dodge = cc.getOrganScore(CCOrganScores.ARROW_DODGING);
        if (dodge == 0.0f) {
            return false;
        }
        if (cc.owner.m_21023_((MobEffect)CCStatusEffects.ARROW_DODGE_COOLDOWN.get())) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource)) {
            return false;
        }
        if (!OrganUtil.teleportRandomly(cc.owner, (float)ChestCavity.config.ARROW_DODGE_DISTANCE / dodge)) {
            return false;
        }
        cc.owner.m_7292_(new MobEffectInstance((MobEffect)CCStatusEffects.ARROW_DODGE_COOLDOWN.get(), (int)((float)ChestCavity.config.ARROW_DODGE_COOLDOWN / dodge), 0, false, false, true));
        return true;
    }

    public static void clearForbiddenSlots(ChestCavityInstance cc) {
        try {
            cc.inventory.m_19181_(cc);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < cc.inventory.m_6643_(); ++i) {
            if (!cc.getChestCavityType().isSlotForbidden(i)) continue;
            cc.owner.m_19983_(cc.inventory.m_8016_(i));
        }
        cc.inventory.m_19164_(cc);
    }

    public static void destroyOrgansWithKey(ChestCavityInstance cc, ResourceLocation organ) {
        for (int i = 0; i < cc.inventory.m_6643_(); ++i) {
            OrganData organData;
            ItemStack slot = cc.inventory.m_8020_(i);
            if (slot == null || slot == ItemStack.f_41583_ || (organData = ChestCavityUtil.lookupOrgan(slot, cc.getChestCavityType())) == null || !organData.organScores.containsKey(organ)) continue;
            cc.inventory.m_8016_(i);
        }
        cc.inventory.m_6596_();
    }

    public static boolean determineDefaultOrganScores(ChestCavityType chestCavityType) {
        Map<ResourceLocation, Float> organScores = chestCavityType.getDefaultOrganScores();
        chestCavityType.loadBaseOrganScores(organScores);
        try {
            for (int i = 0; i < chestCavityType.getDefaultChestCavity().m_6643_(); ++i) {
                ItemStack itemStack = chestCavityType.getDefaultChestCavity().m_8020_(i);
                if (itemStack == null || itemStack == ItemStack.f_41583_) continue;
                Item slotitem = itemStack.m_41720_();
                OrganData data = ChestCavityUtil.lookupOrgan(itemStack, chestCavityType);
                if (data == null) continue;
                data.organScores.forEach((key, value) -> ChestCavityUtil.addOrganScore(key, value.floatValue() * Math.min((float)itemStack.m_41613_() / (float)itemStack.m_41741_(), 1.0f), organScores));
            }
            return true;
        }
        catch (IllegalStateException var6) {
            ChestCavity.LOGGER.warn(var6.getMessage() + ". Chest Cavity will attempt to calculate this default organ score later.");
            return false;
        }
    }

    public static void drawOrgansFromPile(List<ItemStack> organPile, int rolls, RandomSource random, List<ItemStack> loot) {
        for (int i = 0; i < rolls && !organPile.isEmpty(); ++i) {
            int roll = random.m_188503_(organPile.size());
            int count = 1;
            ItemStack rolledItem = organPile.remove(roll).m_41777_();
            if (rolledItem.m_41613_() > 1) {
                count += random.m_188503_(rolledItem.m_41741_());
            }
            rolledItem.m_41764_(count);
            loot.add(rolledItem);
        }
    }

    public static void dropUnboundOrgans(ChestCavityInstance cc) {
        if (!ChestCavity.config.REQUIEM_INTEGRATION || ForgeRegistries.ENTITY_TYPES.getKey((Object)cc.owner.m_6095_()).compareTo(CCRequiem.PLAYER_SHELL_ID) != 0) {
            try {
                cc.inventory.m_19181_(cc);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            for (int i = 0; i < cc.inventory.m_6643_(); ++i) {
                int compatibility;
                ItemStack itemStack = cc.inventory.m_8020_(i);
                if (itemStack == null || itemStack == ItemStack.f_41583_ || (compatibility = ChestCavityUtil.getCompatibilityLevel(cc, itemStack)) >= 2) continue;
                cc.owner.m_19983_(cc.inventory.m_8016_(i));
            }
            cc.inventory.m_19164_(cc);
            ChestCavityUtil.evaluateChestCavity(cc);
        }
    }

    public static void evaluateChestCavity(ChestCavityInstance cc) {
        Map<ResourceLocation, Float> organScores = cc.getOrganScores();
        if (!cc.opened) {
            organScores.clear();
            if (cc.getChestCavityType().getDefaultOrganScores() != null) {
                organScores.putAll(cc.getChestCavityType().getDefaultOrganScores());
            }
        } else {
            cc.onHitListeners.clear();
            cc.getChestCavityType().loadBaseOrganScores(organScores);
            for (int i = 0; i < cc.inventory.m_6643_(); ++i) {
                int compatibility;
                ItemStack itemStack = cc.inventory.m_8020_(i);
                if (itemStack == null || itemStack == ItemStack.f_41583_) continue;
                Item slotitem = itemStack.m_41720_();
                OrganData data = ChestCavityUtil.lookupOrgan(itemStack, cc.getChestCavityType());
                if (data == null) continue;
                data.organScores.forEach((key, value) -> ChestCavityUtil.addOrganScore(key, value.floatValue() * Math.min((float)itemStack.m_41613_() / (float)itemStack.m_41741_(), 1.0f), organScores));
                if (slotitem instanceof OrganOnHitListener) {
                    cc.onHitListeners.add(new OrganOnHitContext(itemStack, (OrganOnHitListener)slotitem));
                }
                if (data.pseudoOrgan || (compatibility = ChestCavityUtil.getCompatibilityLevel(cc, itemStack)) >= 1) continue;
                ChestCavityUtil.addOrganScore(CCOrganScores.INCOMPATIBILITY, 1.0f, organScores);
            }
        }
        ChestCavityUtil.organUpdate(cc);
    }

    public static void forcefullyAddStack(ChestCavityInstance cc, ItemStack stack, int slot) {
        if (!cc.inventory.m_19183_(stack)) {
            if (cc.owner.m_20193_().m_46469_().m_46207_(GameRules.f_46133_) && cc.owner instanceof Player) {
                if (!((Player)cc.owner).m_150109_().m_36054_(stack)) {
                    cc.owner.m_19983_(cc.inventory.m_8016_(slot));
                }
            } else {
                cc.owner.m_19983_(cc.inventory.m_8016_(slot));
            }
        }
        cc.inventory.m_19173_(stack);
    }

    public static void generateChestCavityIfOpened(ChestCavityInstance cc) {
        if (cc.opened) {
            cc.inventory.readTags(cc.getChestCavityType().getDefaultChestCavity().getTags());
            cc.getChestCavityType().setOrganCompatibility(cc);
        }
    }

    public static int getCompatibilityLevel(ChestCavityInstance cc, ItemStack itemStack) {
        if (itemStack != null && itemStack != ItemStack.f_41583_) {
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)CCEnchantments.MALPRACTICE.get()), (ItemStack)itemStack) > 0) {
                return 0;
            }
            int oNegative = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)CCEnchantments.O_NEGATIVE.get()), (ItemStack)itemStack);
            int ownership = 0;
            CompoundTag tag = itemStack.m_41783_();
            if (tag != null && tag.m_128441_(ChestCavity.COMPATIBILITY_TAG.toString())) {
                if ((tag = tag.m_128469_(ChestCavity.COMPATIBILITY_TAG.toString())).m_128342_("owner").equals(cc.compatibility_id)) {
                    ownership = 2;
                }
            } else {
                ownership = 1;
            }
            return Math.max(oNegative, ownership);
        }
        return 1;
    }

    public static void insertWelfareOrgans(ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.HEALTH) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((ItemLike)CCItems.ROTTEN_HEART.get()), 4);
        }
        if (cc.getOrganScore(CCOrganScores.BREATH_RECOVERY) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((ItemLike)CCItems.ROTTEN_LUNG.get()), 3);
        }
        if (cc.getOrganScore(CCOrganScores.NERVES) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((ItemLike)CCItems.ROTTEN_SPINE.get()), 13);
        }
        if (cc.getOrganScore(CCOrganScores.STRENGTH) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((ItemLike)Items.f_42583_, 16), 0);
        }
    }

    public static boolean isHydroPhobicOrAllergic(LivingEntity entity) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((Entity)entity);
        if (optional.isEmpty()) {
            return false;
        }
        ChestCavityInstance cc = optional.get().getChestCavityInstance();
        return cc.getOrganScore(CCOrganScores.HYDROALLERGENIC) > 0.0f || cc.getOrganScore(CCOrganScores.HYDROPHOBIA) > 0.0f;
    }

    public static OrganData lookupOrgan(ItemStack itemStack, ChestCavityType cct) {
        TagKey<Item> itemTag;
        OrganData organData = null;
        if (cct != null) {
            organData = cct.catchExceptionalOrgan(itemStack);
        }
        if (organData != null) {
            return organData;
        }
        organData = OrganManager.readNBTOrganData(itemStack);
        if (organData != null) {
            return organData;
        }
        Item var4 = itemStack.m_41720_();
        if (var4 instanceof CCOrganItem) {
            CCOrganItem oItem = (CCOrganItem)var4;
            return oItem.getOrganData(itemStack);
        }
        if (OrganManager.hasEntry(itemStack.m_41720_())) {
            return OrganManager.getEntry(itemStack.m_41720_());
        }
        Iterator<TagKey<Item>> var6 = CCTagOrgans.tagMap.keySet().iterator();
        do {
            if (var6.hasNext()) continue;
            return null;
        } while (!itemStack.m_204117_(itemTag = var6.next()));
        organData = new OrganData();
        organData.pseudoOrgan = true;
        organData.organScores = CCTagOrgans.tagMap.get(itemTag);
        return organData;
    }

    public static MobEffectInstance onAddStatusEffect(ChestCavityInstance cc, MobEffectInstance effect) {
        return OrganAddStatusEffectListeners.call(cc.owner, cc, effect);
    }

    public static void onDeath(ChestCavityEntity entity) {
        ChestCavityInstance ccinstance = entity.getChestCavityInstance();
        ccinstance.getChestCavityType().onDeath(ccinstance);
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (!ChestCavity.config.KEEP_CHEST_CAVITY) {
                HashMap<Integer, ItemStack> organsToKeep = new HashMap<Integer, ItemStack>();
                for (int i = 0; i < ccinstance.inventory.m_6643_(); ++i) {
                    ItemStack organ = ccinstance.inventory.m_8020_(i);
                    if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)CCEnchantments.O_NEGATIVE.get()), (ItemStack)organ) < 2) continue;
                    organsToKeep.put(i, organ.m_41777_());
                }
                ccinstance.compatibility_id = UUID.randomUUID();
                ChestCavityUtil.generateChestCavityIfOpened(ccinstance);
                for (Map.Entry entry : organsToKeep.entrySet()) {
                    ccinstance.inventory.m_6836_((Integer)entry.getKey(), (ItemStack)entry.getValue());
                }
            }
            ChestCavityUtil.insertWelfareOrgans(ccinstance);
        }
    }

    public static float onHit(ChestCavityInstance cc, DamageSource source, LivingEntity target, float damage) {
        if (cc.opened) {
            for (OrganOnHitContext e : cc.onHitListeners) {
                damage = e.listener.onHit(source, cc.owner, target, cc, e.organ, damage);
            }
            ChestCavityUtil.organUpdate(cc);
        }
        return damage;
    }

    public static void onTick(ChestCavityInstance cc) {
        if (cc.updatePacket) {
            NetworkUtil.SendS2CChestCavityUpdatePacket(cc, cc.updatePacket);
        }
        if (cc.opened) {
            OrganTickListeners.call(cc.owner, cc);
            ChestCavityUtil.organUpdate(cc);
        }
    }

    public static ChestCavityInventory openChestCavity(ChestCavityInstance cc) {
        if (!cc.opened) {
            try {
                cc.inventory.m_19181_(cc);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            cc.opened = true;
            ChestCavityUtil.generateChestCavityIfOpened(cc);
            cc.inventory.m_19164_(cc);
        }
        return cc.inventory;
    }

    public static void organUpdate(ChestCavityInstance cc) {
        Map<ResourceLocation, Float> organScores = cc.getOrganScores();
        if (!cc.oldOrganScores.equals(organScores)) {
            OrganUpdateListeners.call(cc.owner, cc);
            cc.oldOrganScores.clear();
            cc.oldOrganScores.putAll(organScores);
            NetworkUtil.SendS2CChestCavityUpdatePacket(cc);
        }
    }

    public static void outputOrganScoresString(Consumer<String> output, ChestCavityInstance cc) {
        try {
            Component name = cc.owner.m_5446_();
            output.accept("[Chest Cavity] Displaying " + name.getString() + "'s organ scores:");
        }
        catch (Exception var3) {
            output.accept("[Chest Cavity] Displaying organ scores:");
        }
        cc.getOrganScores().forEach((key, value) -> {
            String var10001 = key.m_135815_();
            output.accept(var10001 + ": " + value + " ");
        });
    }

    public static void splashHydrophobicWithWater(ThrownPotion splash) {
        AABB box = splash.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = splash.f_19853_.m_6443_(LivingEntity.class, box, ChestCavityUtil::isHydroPhobicOrAllergic);
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                Optional<ChestCavityEntity> optional;
                double d = splash.m_20280_((Entity)livingEntity);
                if (!(d < 16.0) || !(optional = ChestCavityEntity.of((Entity)livingEntity)).isPresent()) continue;
                ChestCavityInstance cc = optional.get().getChestCavityInstance();
                float allergy = cc.getOrganScore(CCOrganScores.HYDROALLERGENIC);
                float phobia = cc.getOrganScore(CCOrganScores.HYDROPHOBIA);
                if (allergy > 0.0f) {
                    livingEntity.m_6469_(DamageSource.m_19367_((Entity)livingEntity, (Entity)splash.m_37282_()), allergy / 26.0f);
                }
                if (!(phobia > 0.0f)) continue;
                OrganUtil.teleportRandomly(livingEntity, phobia * 32.0f);
            }
        }
    }
}

