/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.recipes.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.tigereye.chestcavity.recipes.SalvageRecipe;
import net.tigereye.chestcavity.recipes.json.SalvageRecipeJsonFormat;

public class SalvageRecipeSerializer
implements RecipeSerializer<SalvageRecipe> {
    public SalvageRecipe fromJson(ResourceLocation id, JsonObject json) {
        SalvageRecipeJsonFormat recipeJson = (SalvageRecipeJsonFormat)new Gson().fromJson((JsonElement)json, SalvageRecipeJsonFormat.class);
        if (recipeJson.ingredient != null && recipeJson.result != null) {
            if (recipeJson.required == 0) {
                recipeJson.required = 1;
            }
            if (recipeJson.count == 0) {
                recipeJson.count = 1;
            }
            Ingredient input = Ingredient.m_43917_((JsonElement)recipeJson.ingredient);
            Item outputItem = Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(recipeJson.result))).orElseThrow(() -> new JsonSyntaxException("No such item " + recipeJson.result));
            ItemStack output = new ItemStack((ItemLike)outputItem, recipeJson.count);
            return new SalvageRecipe(input, recipeJson.required, output, id);
        }
        throw new JsonSyntaxException("A required attribute is missing!");
    }

    public SalvageRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int required = buf.readInt();
        ItemStack output = buf.m_130267_();
        return new SalvageRecipe(input, required, output, id);
    }

    public void toNetwork(FriendlyByteBuf buf, SalvageRecipe recipe) {
        recipe.getInput().m_43923_(buf);
        buf.writeInt(recipe.getRequired());
        buf.m_130055_(recipe.m_8043_());
    }
}

