/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.ITeleporter;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstanceFactory;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.items.ChestOpener;
import net.tigereye.chestcavity.listeners.OrganFoodEffectListeners;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.NetworkUtil;
import net.tigereye.chestcavity.util.OrganUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=900)
public abstract class MixinLivingEntity
extends Entity
implements ChestCavityEntity {
    @Unique
    private ChestCavityInstance chestCavityInstance;

    @Shadow
    protected abstract int m_7305_(int var1);

    protected MixinLivingEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void chestCavityLivingEntityConstructorMixin(EntityType<? extends LivingEntity> entityType, Level world, CallbackInfo info) {
        this.chestCavityInstance = ChestCavityInstanceFactory.newChestCavityInstance(entityType, (LivingEntity)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"baseTick"})
    public void chestCavityLivingEntityBaseTickMixin(CallbackInfo info) {
        ChestCavityUtil.onTick(this.chestCavityInstance);
    }

    @Inject(at={@At(value="TAIL")}, method={"baseTick"})
    protected void chestCavityLivingEntityBaseTickBreathAirMixin(CallbackInfo info) {
        if (!this.m_204029_(FluidTags.f_13131_) || this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_())).m_60713_(Blocks.f_50628_)) {
            this.m_20301_(ChestCavityUtil.applyBreathOnLand(this.chestCavityInstance, this.m_20146_(), this.m_7305_(0)));
        }
    }

    @ModifyVariable(at=@At(value="CONSTANT", args={"floatValue=0.0F"}, ordinal=0), ordinal=0, method={"actuallyHurt"}, argsOnly=true)
    public float chestCavityLivingEntityOnHitMixin(float amount, DamageSource source) {
        Optional<ChestCavityEntity> cce;
        if (source.m_7639_() instanceof LivingEntity && (cce = ChestCavityEntity.of(source.m_7639_())).isPresent()) {
            amount = ChestCavityUtil.onHit(cce.get().getChestCavityInstance(), source, (LivingEntity)this, amount);
        }
        return amount;
    }

    @Inject(at={@At(value="RETURN")}, method={"decreaseAirSupply"}, cancellable=true)
    protected void chestCavityLivingEntityGetNextAirUnderwaterMixin(int air, CallbackInfoReturnable<Integer> info) {
        info.setReturnValue((Object)ChestCavityUtil.applyBreathInWater(this.chestCavityInstance, air, info.getReturnValueI()));
    }

    @Inject(at={@At(value="RETURN")}, method={"getDamageAfterArmorAbsorb"}, cancellable=true)
    public void chestCavityLivingEntityDamageMixin(DamageSource source, float amount, CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)Float.valueOf(ChestCavityUtil.applyDefenses(this.chestCavityInstance, source, info.getReturnValueF())));
    }

    @Inject(at={@At(value="HEAD")}, method={"dropEquipment"})
    public void chestCavityLivingEntityDropInventoryMixin(CallbackInfo info) {
        ChestCavityUtil.onDeath(this);
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, ordinal=0, argsOnly=true)
    public MobEffectInstance chestCavityLivingEntityAddStatusEffectMixin(MobEffectInstance effect) {
        return ChestCavityUtil.onAddStatusEffect(this.chestCavityInstance, effect);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodProperties;getEffects()Ljava/util/List;"), method={"addEatEffect"})
    public List<Pair<MobEffectInstance, Float>> chestCavityLivingEntityApplyFoodEffectsMixin(FoodProperties instance, ItemStack stack, Level world, LivingEntity targetEntity) {
        LinkedList<Pair<MobEffectInstance, Float>> list = instance.m_38749_();
        Optional<ChestCavityEntity> option = ChestCavityEntity.of((Entity)targetEntity);
        if (option.isPresent()) {
            list = new LinkedList<Pair<MobEffectInstance, Float>>(list);
            OrganFoodEffectListeners.call(list, stack, world, targetEntity, option.get().getChestCavityInstance());
        }
        return list;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;moveRelative(FLnet/minecraft/world/phys/Vec3;)V"), method={"travel"}, index=0, require=0)
    protected float chestCavityLivingEntityWaterTravelMixin(float g) {
        return g * ChestCavityUtil.applySwimSpeedInWater(this.chestCavityInstance);
    }

    @Inject(at={@At(value="RETURN")}, method={"getJumpPower"}, cancellable=true)
    public void chestCavityLivingEntityJumpVelocityMixin(CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)ChestCavityUtil.applyLeaping(this.chestCavityInstance, info.getReturnValueF()));
    }

    @Override
    public ChestCavityInstance getChestCavityInstance() {
        return this.chestCavityInstance;
    }

    @Override
    public void setChestCavityInstance(ChestCavityInstance chestCavityInstance) {
        this.chestCavityInstance = chestCavityInstance;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundTag tag, CallbackInfo callbackInfo) {
        this.chestCavityInstance.fromTag(tag, (LivingEntity)this);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundTag tag, CallbackInfo callbackInfo) {
        this.chestCavityInstance.toTag(tag);
    }

    @Mixin(value={net.minecraft.world.entity.Mob.class})
    private static abstract class Mob
    extends LivingEntity {
        protected Mob(EntityType<? extends LivingEntity> entityType, Level world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"checkAndHandleImportantInteractions"}, cancellable=true)
        protected void chestCavityLivingEntityInteractMobMixin(net.minecraft.world.entity.player.Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
            if (player.m_21120_(hand).m_41720_() == CCItems.CHEST_OPENER.get() && !(this instanceof net.minecraft.world.entity.player.Player)) {
                ((ChestOpener)player.m_21120_(hand).m_41720_()).openChestCavity(player, this);
                info.setReturnValue((Object)InteractionResult.SUCCESS);
            }
        }
    }

    @Mixin(value={net.minecraft.world.entity.player.Player.class})
    public static abstract class Player
    extends LivingEntity {
        protected Player(EntityType<? extends LivingEntity> entityType, Level world) {
            super(entityType, world);
        }

        @ModifyVariable(at=@At(value="CONSTANT", args={"floatValue=0.0F"}, ordinal=0), ordinal=0, method={"actuallyHurt"}, argsOnly=true)
        public float chestCavityPlayerEntityOnHitMixin(float amount, DamageSource source) {
            Optional<ChestCavityEntity> cce;
            if (source.m_7639_() instanceof LivingEntity && (cce = ChestCavityEntity.of(source.m_7639_())).isPresent()) {
                amount = ChestCavityUtil.onHit(cce.get().getChestCavityInstance(), source, this, amount);
            }
            return amount;
        }

        @Inject(at={@At(value="HEAD")}, method={"interactOn"}, cancellable=true)
        void chestCavityPlayerEntityInteractPlayerMixin(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
            net.minecraft.world.entity.player.Player player;
            ItemStack stack;
            if (entity instanceof LivingEntity && ChestCavity.config.CAN_OPEN_OTHER_PLAYERS && (stack = (player = (net.minecraft.world.entity.player.Player)this).m_21120_(hand)).m_41720_() == CCItems.CHEST_OPENER.get()) {
                ((ChestOpener)stack.m_41720_()).openChestCavity(player, (LivingEntity)entity);
                info.setReturnValue((Object)InteractionResult.SUCCESS);
                info.cancel();
            }
        }

        @Inject(at={@At(value="RETURN")}, method={"getDestroySpeed"}, cancellable=true)
        void chestCavityPlayerEntityGetBlockBreakingSpeedMixin(BlockState block, CallbackInfoReturnable<Float> cir) {
            cir.setReturnValue((Object)Float.valueOf(ChestCavityUtil.applyNervesToMining(((ChestCavityEntity)((Object)this)).getChestCavityInstance(), ((Float)cir.getReturnValue()).floatValue())));
        }
    }

    @Mixin(value={net.minecraft.world.entity.animal.Cow.class})
    private static abstract class Cow
    extends Animal {
        protected Cow(EntityType<? extends Animal> entityType, Level world) {
            super(entityType, world);
        }

        @Inject(method={"mobInteract"}, at={@At(value="RETURN", ordinal=0)})
        protected void interactMob(net.minecraft.world.entity.player.Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
            OrganUtil.milkSilk((LivingEntity)this);
        }
    }

    @Mixin(value={net.minecraft.world.entity.monster.Creeper.class})
    private static abstract class Creeper
    extends Monster {
        @Shadow
        private int f_32270_;

        protected Creeper(EntityType<? extends Monster> entityType, Level world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"tick"})
        protected void chestCavityCreeperTickMixin(CallbackInfo info) {
            if (this.m_6084_() && this.f_32270_ > 1) {
                ChestCavityEntity.of((Entity)this).ifPresent(cce -> {
                    if (cce.getChestCavityInstance().opened && cce.getChestCavityInstance().getOrganScore(CCOrganScores.CREEPY) <= 0.0f) {
                        this.f_32270_ = 1;
                    }
                });
            }
        }
    }

    @Mixin(value={ServerPlayer.class})
    private static abstract class Server
    extends net.minecraft.world.entity.player.Player {
        public Server(Level world, BlockPos pos, float yaw, GameProfile profile, ProfilePublicKey playerPublicKey) {
            super(world, pos, yaw, profile, playerPublicKey);
        }

        @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
        public void copyFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo callbackInfo) {
            ChestCavityEntity.of((Entity)this).ifPresent(chestCavityEntity -> ChestCavityEntity.of((Entity)oldPlayer).ifPresent(oldCCPlayerEntityInterface -> chestCavityEntity.getChestCavityInstance().clone(oldCCPlayerEntityInterface.getChestCavityInstance())));
        }

        @Inject(at={@At(value="RETURN")}, method={"changeDimension"}, remap=false)
        public void chestCavityEntityMoveToWorldMixin(ServerLevel destination, ITeleporter teleporter, CallbackInfoReturnable<Entity> info) {
            Entity entity = (Entity)info.getReturnValue();
            if (entity instanceof ChestCavityEntity && !entity.f_19853_.f_46443_) {
                NetworkUtil.SendS2CChestCavityUpdatePacket(((ChestCavityEntity)entity).getChestCavityInstance());
            }
        }
    }

    @Mixin(value={net.minecraft.world.entity.animal.Sheep.class})
    private static abstract class Sheep
    extends Animal {
        protected Sheep(EntityType<? extends Animal> entityType, Level world) {
            super(entityType, world);
        }

        @Inject(method={"shear"}, at={@At(value="HEAD")})
        protected void chestCavitySheared(SoundSource shearedSoundCategory, CallbackInfo info) {
            OrganUtil.shearSilk((LivingEntity)this);
        }
    }

    @Mixin(value={WitherBoss.class})
    private static abstract class Wither
    extends Monster {
        protected Wither(EntityType<? extends Monster> entityType, Level world) {
            super(entityType, world);
        }

        @Inject(method={"dropCustomDeathLoot"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/boss/wither/WitherBoss;spawnAtLocation(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/entity/item/ItemEntity;")}, cancellable=true)
        protected void chestCavityPreventNetherStarDrop(DamageSource source, int lootingMultiplier, boolean allowDrops, CallbackInfo info) {
            Optional<ChestCavityEntity> chestCavityEntity = ChestCavityEntity.of((Entity)this);
            if (chestCavityEntity.isPresent()) {
                ChestCavityInstance cc = chestCavityEntity.get().getChestCavityInstance();
                if (cc.opened && cc.inventory.m_18947_(Items.f_42686_) == 0) {
                    info.cancel();
                }
            }
        }
    }
}

