/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.registration.CCOrganScores;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity {
    @ModifyVariable(at=@At(value="HEAD"), ordinal=0, method={"checkFallDamage"}, argsOnly=true)
    public double chestCavityEntityFallMixin(double finalHeightDifference, double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        Optional<ChestCavityEntity> cce;
        if (heightDifference < 0.0 && (cce = ChestCavityEntity.of((Entity)this)).isPresent()) {
            finalHeightDifference = heightDifference * (double)(1.0f - cce.get().getChestCavityInstance().getOrganScore(CCOrganScores.BUOYANT) / 3.0f);
        }
        return finalHeightDifference;
    }

    @Inject(at={@At(value="RETURN")}, method={"interact"}, cancellable=true)
    public void chestCavityEntityInteractMixin(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
        if (info.getReturnValue() == InteractionResult.PASS && (Entity)this instanceof EnderDragonPart) {
            ChestCavity.LOGGER.info("Attempting to open dragon's " + ((EnderDragonPart)this).f_31011_);
            EnderDragon dragon = ((EnderDragonPart)this).f_31010_;
            if (dragon != null) {
                ChestCavity.LOGGER.info("Dragon was not null");
                info.setReturnValue((Object)dragon.m_6096_(player, hand));
            }
        }
    }
}

