/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.listeners.Listeners;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootTable.class})
public class LootTableGenerateLootMixin {
    @Unique
    List<ItemStack> interceptedLoot = new ArrayList<ItemStack>();
    @Unique
    Consumer<ItemStack> interceptedConsumer;

    @ModifyVariable(method={"getRandomItemsRaw"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public Consumer<ItemStack> generateUnprocessedLootMixin_InterceptConsumerReplaceWithList(Consumer<ItemStack> lootConsumer) {
        this.interceptedLoot.clear();
        this.interceptedConsumer = lootConsumer;
        return this.interceptedLoot::add;
    }

    @Inject(method={"getRandomItemsRaw"}, at={@At(value="TAIL")})
    public void generateUnprocessedLootMixin_ModifyPopulatedListAndFeedConsumer(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        if (ChestCavity.config.DEBUG_MODE) {
            ChestCavity.LOGGER.debug("modifying " + this.interceptedLoot.size() + " drops");
        }
        this.interceptedLoot.addAll(Listeners.addLoot(((LootTable)this).m_79122_(), context));
        this.interceptedLoot = Listeners.modifyLoot(((LootTable)this).m_79122_(), context, this.interceptedLoot);
        if (ChestCavity.config.DEBUG_MODE) {
            ChestCavity.LOGGER.debug(this.interceptedLoot.size() + " itemStacks returned");
        }
        Consumer processedConsumer = LootTable.m_79142_(this.interceptedConsumer);
        for (ItemStack stack : this.interceptedLoot) {
            processedConsumer.accept(stack);
        }
    }
}

