/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.registration.CCDamageSource;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.util.OrganUtil;

public class OrganTickListeners {
    public static void call(LivingEntity entity, ChestCavityInstance cc) {
        OrganTickListeners.TickIncompatibility(entity, cc);
        OrganTickListeners.TickProjectileQueue(entity, cc);
        OrganTickListeners.TickHealth(entity, cc);
        OrganTickListeners.TickFiltration(entity, cc);
        OrganTickListeners.TickBuoyant(entity, cc);
        OrganTickListeners.TickCrystalsynthesis(entity, cc);
        OrganTickListeners.TickPhotosynthesis(entity, cc);
        OrganTickListeners.TickHydroallergenic(entity, cc);
        OrganTickListeners.TickHydrophobia(entity, cc);
        OrganTickListeners.TickGlowing(entity, cc);
    }

    public static void TickBuoyant(LivingEntity entity, ChestCavityInstance chestCavity) {
        Player ent;
        float buoyancy = chestCavity.getOrganScore(CCOrganScores.BUOYANT) - chestCavity.getChestCavityType().getDefaultOrganScore(CCOrganScores.BUOYANT);
        if (entity instanceof Player && (ent = (Player)entity).m_7500_() && ent.m_150110_().f_35935_) {
            return;
        }
        if (!entity.m_20096_() && !entity.m_20068_() && buoyancy != 0.0f) {
            entity.m_5997_(0.0, (double)buoyancy * 0.02, 0.0);
        }
    }

    public static void TickCrystalsynthesis(LivingEntity entity, ChestCavityInstance cc) {
        float crystalsynthesis = cc.getOrganScore(CCOrganScores.CRYSTALSYNTHESIS);
        if (cc.connectedCrystal != null) {
            if (cc.connectedCrystal.m_213877_()) {
                entity.m_6469_(DamageSource.f_19313_, crystalsynthesis * 2.0f);
                cc.connectedCrystal = null;
            } else if (crystalsynthesis != 0.0f) {
                cc.connectedCrystal.m_31052_(entity.m_20183_().m_6625_(2));
            } else {
                cc.connectedCrystal.m_31052_(null);
                cc.connectedCrystal = null;
            }
        }
        if (crystalsynthesis != 0.0f && entity.f_19853_.m_46467_() % (long)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY == 0L && !(entity instanceof EnderDragon)) {
            EndCrystal oldcrystal = cc.connectedCrystal;
            List list = entity.f_19853_.m_45976_(EndCrystal.class, entity.m_20191_().m_82400_((double)ChestCavity.config.CRYSTALSYNTHESIS_RANGE));
            EndCrystal endCrystalEntity = null;
            double d = Double.MAX_VALUE;
            for (EndCrystal endCrystalEntity2 : list) {
                double e = endCrystalEntity2.m_20280_((Entity)entity);
                if (!(e < d)) continue;
                d = e;
                endCrystalEntity = endCrystalEntity2;
            }
            cc.connectedCrystal = endCrystalEntity;
            if (oldcrystal != null && oldcrystal != cc.connectedCrystal) {
                oldcrystal.m_31052_(null);
            }
            if (cc.connectedCrystal != null) {
                if (entity instanceof Player) {
                    Player playerEntity = (Player)entity;
                    FoodData hungerManager = playerEntity.m_36324_();
                    if (hungerManager.m_38721_()) {
                        if (crystalsynthesis >= 5.0f || (float)(entity.f_19853_.m_46467_() % ((long)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY * 5L)) < (float)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY * crystalsynthesis) {
                            hungerManager.m_38707_(1, 0.0f);
                        }
                    } else if (hungerManager.m_38722_() < (float)hungerManager.m_38702_()) {
                        hungerManager.m_38707_(1, crystalsynthesis / 10.0f);
                    } else {
                        playerEntity.m_5634_(crystalsynthesis / 5.0f);
                    }
                } else {
                    entity.m_5634_(crystalsynthesis / 5.0f);
                }
            }
        }
    }

    public static void TickPhotosynthesis(LivingEntity entity, ChestCavityInstance cc) {
        float photosynthesis;
        if (!entity.m_9236_().m_5776_() && (photosynthesis = cc.getOrganScore(CCOrganScores.PHOTOSYNTHESIS) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.PHOTOSYNTHESIS)) > 0.0f) {
            cc.photosynthesisProgress = (int)((float)cc.photosynthesisProgress + photosynthesis * (float)entity.m_9236_().m_46803_(entity.m_20183_()));
            if (cc.photosynthesisProgress > ChestCavity.config.PHOTOSYNTHESIS_FREQUENCY * 8 * 15) {
                cc.photosynthesisProgress = 0;
                if (entity instanceof Player) {
                    Player playerEntity = (Player)entity;
                    FoodData hungerManager = playerEntity.m_36324_();
                    if (hungerManager.m_38721_()) {
                        hungerManager.m_38707_(1, 0.0f);
                    } else if (hungerManager.m_38722_() < (float)hungerManager.m_38702_()) {
                        hungerManager.m_38707_(1, 0.5f);
                    } else {
                        playerEntity.m_5634_(1.0f);
                    }
                } else {
                    entity.m_5634_(1.0f);
                }
            }
        }
    }

    public static void TickHealth(LivingEntity entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.HEALTH) <= 0.0f && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HEALTH) != 0.0f) {
            if (entity.f_19853_.m_46467_() % (long)ChestCavity.config.HEARTBLEED_RATE == 0L) {
                ++cc.heartBleedTimer;
                entity.m_6469_(CCDamageSource.HEARTBLEED, Math.min((float)cc.heartBleedTimer, cc.getChestCavityType().getHeartBleedCap()));
            }
        } else {
            cc.heartBleedTimer = 0;
        }
    }

    public static void TickFiltration(LivingEntity entity, ChestCavityInstance cc) {
        float KidneyRatio;
        if (!entity.m_20193_().m_5776_() && !(cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION) <= 0.0f) && (KidneyRatio = cc.getOrganScore(CCOrganScores.FILTRATION) / cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION)) < 1.0f) {
            ++cc.bloodPoisonTimer;
            if (cc.bloodPoisonTimer >= ChestCavity.config.KIDNEY_RATE) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, (int)Math.max(1.0f, 48.0f * (1.0f - KidneyRatio))));
                cc.bloodPoisonTimer = 0;
            }
        }
    }

    private static void TickProjectileQueue(LivingEntity entity, ChestCavityInstance cc) {
        if (cc.projectileCooldown > 0) {
            --cc.projectileCooldown;
        } else if (!cc.projectileQueue.isEmpty()) {
            cc.projectileCooldown = 5;
            cc.projectileQueue.pop().accept(entity);
        }
    }

    private static void TickHydroallergenic(LivingEntity entity, ChestCavityInstance cc) {
        float Hydroallergy;
        if (!entity.m_20193_().m_5776_() && !((Hydroallergy = cc.getOrganScore(CCOrganScores.HYDROALLERGENIC)) <= 0.0f)) {
            if (entity.m_5842_()) {
                if (!entity.m_21023_((MobEffect)CCStatusEffects.WATER_VULNERABILITY.get())) {
                    entity.m_6469_(DamageSource.f_19319_, 10.0f);
                    entity.m_7292_(new MobEffectInstance((MobEffect)CCStatusEffects.WATER_VULNERABILITY.get(), (int)(260.0f / Hydroallergy), 0, false, false, true));
                }
            } else if (entity.m_20070_() && !entity.m_21023_((MobEffect)CCStatusEffects.WATER_VULNERABILITY.get())) {
                entity.m_6469_(DamageSource.f_19319_, 1.0f);
                entity.m_7292_(new MobEffectInstance((MobEffect)CCStatusEffects.WATER_VULNERABILITY.get(), (int)(260.0f / Hydroallergy), 0, false, false, true));
            }
        }
    }

    public static void TickHydrophobia(LivingEntity entity, ChestCavityInstance cc) {
        float hydrophobia = cc.getOrganScore(CCOrganScores.HYDROPHOBIA);
        if (!(hydrophobia <= 0.0f) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HYDROPHOBIA) == 0.0f && entity.m_20070_()) {
            OrganUtil.teleportRandomly(entity, hydrophobia * 32.0f);
        }
    }

    public static void TickIncompatibility(LivingEntity entity, ChestCavityInstance chestCavity) {
        float incompatibility;
        if (!entity.m_20193_().m_5776_() && !ChestCavity.config.DISABLE_ORGAN_REJECTION && (incompatibility = chestCavity.getOrganScore(CCOrganScores.INCOMPATIBILITY)) > 0.0f && !entity.m_21023_((MobEffect)CCStatusEffects.ORGAN_REJECTION.get())) {
            entity.m_7292_(new MobEffectInstance((MobEffect)CCStatusEffects.ORGAN_REJECTION.get(), (int)((float)ChestCavity.config.ORGAN_REJECTION_RATE / incompatibility), 0, false, true, true));
        }
    }

    public static void TickGlowing(LivingEntity entity, ChestCavityInstance chestCavity) {
        float glowing;
        if (!entity.m_20193_().m_5776_() && (glowing = chestCavity.getOrganScore(CCOrganScores.GLOWING)) > 0.0f && !entity.m_21023_(MobEffects.f_19619_)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0, false, true, true));
        }
    }
}

