/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.organs;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganJsonFormat;
import net.tigereye.chestcavity.chestcavities.organs.OrganSerializer;
import net.tigereye.chestcavity.forge.port.SimpleSynchronousResourceReloadListener;
import org.jetbrains.annotations.NotNull;

public class OrganManager
implements SimpleSynchronousResourceReloadListener {
    private static final String RESOURCE_LOCATION = "organs";
    private static final String NBT_KEY = "organData";
    private final OrganSerializer SERIALIZER = new OrganSerializer();
    public static Map<ResourceLocation, OrganData> GeneratedOrganData = new HashMap<ResourceLocation, OrganData>();

    @Override
    public ResourceLocation getFabricId() {
        return new ResourceLocation("chestcavity", RESOURCE_LOCATION);
    }

    public void m_6213_(ResourceManager manager) {
        GeneratedOrganData.clear();
        ChestCavity.LOGGER.info("Loading organs.");
        manager.m_214159_(RESOURCE_LOCATION, path -> path.m_135815_().endsWith(".json")).forEach((id, resource) -> {
            try (InputStream stream = resource.m_215507_();){
                InputStreamReader reader = new InputStreamReader(stream);
                Tuple<ResourceLocation, OrganData> organDataPair = this.SERIALIZER.read((ResourceLocation)id, (OrganJsonFormat)new Gson().fromJson((Reader)reader, OrganJsonFormat.class));
                GeneratedOrganData.put((ResourceLocation)organDataPair.m_14418_(), (OrganData)organDataPair.m_14419_());
            }
            catch (Exception var8) {
                ChestCavity.LOGGER.error("Error occurred while loading resource json " + id.toString(), (Throwable)var8);
            }
        });
        ChestCavity.LOGGER.info("Loaded " + GeneratedOrganData.size() + " organs.");
    }

    public static boolean hasEntry(Item item) {
        return GeneratedOrganData.containsKey(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static OrganData getEntry(Item item) {
        return GeneratedOrganData.get(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static boolean isTrueOrgan(Item item) {
        if (OrganManager.hasEntry(item)) {
            return !OrganManager.getEntry((Item)item).pseudoOrgan;
        }
        return false;
    }

    public static OrganData readNBTOrganData(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41737_(NBT_KEY);
        return nbt != null ? OrganManager.readNBTOrganData(nbt) : null;
    }

    public static OrganData readNBTOrganData(@NotNull CompoundTag nbt) {
        OrganData organData = new OrganData();
        organData.pseudoOrgan = nbt.m_128471_("pseudoOrgan");
        for (String key : nbt.m_128431_()) {
            if (key.equals("pseudoOrgan")) continue;
            organData.organScores.put(new ResourceLocation(key), Float.valueOf(nbt.m_128457_(key)));
        }
        return organData;
    }
}

