/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tigereye.chestcavity.ChestCavityClient;
import net.tigereye.chestcavity.compat.CrossModContent;
import net.tigereye.chestcavity.config.CCConfig;
import net.tigereye.chestcavity.forge.network.ChestCavityNetwork;
import net.tigereye.chestcavity.registration.CCCommands;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCListeners;
import net.tigereye.chestcavity.registration.CCNetworkingPackets;
import net.tigereye.chestcavity.registration.CCRecipes;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTagOrgans;
import net.tigereye.chestcavity.ui.ChestCavityScreen;
import net.tigereye.chestcavity.ui.ChestCavityScreenHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="chestcavity")
public class ChestCavity {
    public static final String MODID = "chestcavity";
    public static final boolean DEBUG_MODE = false;
    public static final Logger LOGGER = LogManager.getLogger();
    public static CCConfig config;
    private static final ResourceLocation DESERT_PYRAMID_LOOT_TABLE_ID;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES;
    public static final RegistryObject<MenuType<ChestCavityScreenHandler>> CHEST_CAVITY_SCREEN_HANDLER;
    public static final ResourceLocation CHEST_CAVITY_SCREEN_ID;
    public static final ResourceLocation COMPATIBILITY_TAG;
    public static final CreativeModeTab ORGAN_ITEM_GROUP;

    public ChestCavity() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::clientSetup);
        AutoConfig.register(CCConfig.class, GsonConfigSerializer::new);
        config = (CCConfig)AutoConfig.getConfigHolder(CCConfig.class).getConfig();
        CCItems.ITEMS.register(eventBus);
        CCRecipes.RECIPE_SERIALIZERS.register(eventBus);
        CCRecipes.MCRECIPE_SERIALIZERS.register(eventBus);
        CCRecipes.RECIPE_TYPES.register(eventBus);
        CCEnchantments.ENCHANTMENTS.register(eventBus);
        CCListeners.register();
        CCStatusEffects.MOB_EFFECTS.register(eventBus);
        CCTagOrgans.init();
        CCCommands.register();
        CCNetworkingPackets.register();
        ChestCavityNetwork.init();
        MENU_TYPES.register(eventBus);
        CrossModContent.register();
        eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register((Object)this);
        eventBus.addListener(this::lootTableLoad);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)CHEST_CAVITY_SCREEN_HANDLER.get()), ChestCavityScreen::new);
        ChestCavityClient.onInitializeClient();
    }

    public void lootTableLoad(LootTableLoadEvent event) {
        if (DESERT_PYRAMID_LOOT_TABLE_ID.equals((Object)event.getName())) {
            LootPool.Builder poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)4, (float)0.25f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CCItems.ROTTEN_RIB.get())));
            event.getTable().addPool(poolBuilder.m_79082_());
            poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)1, (float)0.3f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CCItems.ROTTEN_RIB.get())));
            event.getTable().addPool(poolBuilder.m_79082_());
        }
    }

    static {
        DESERT_PYRAMID_LOOT_TABLE_ID = new ResourceLocation("minecraft", "chests/desert_pyramid");
        MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        CHEST_CAVITY_SCREEN_HANDLER = MENU_TYPES.register("chest_cavity_screen", () -> new MenuType(ChestCavityScreenHandler::new));
        CHEST_CAVITY_SCREEN_ID = new ResourceLocation(MODID, "chest_cavity_screen");
        COMPATIBILITY_TAG = new ResourceLocation(MODID, "organ_compatibility");
        ORGAN_ITEM_GROUP = new CreativeModeTab("chestcavity.organs"){

            @NotNull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)CCItems.HUMAN_STOMACH.get());
            }
        };
    }
}

