#if HARDCORE_DARKNESS == 0
	skyLightColor = day > 0.001 ? skylightColorDuringTheDay : skylightColorAtNight;
#elif HARDCORE_DARKNESS == 1
	skyLightColor = day > 0.001 ? skylightColorDuringTheDay : vec3(0.0);
#elif HARDCORE_DARKNESS == 2
	skyLightColor = day > 0.001 ? skylightColorDuringTheDay : skylightColorAtNight * phase;
#else
	#error HARDCORE_DARKNESS should be set to 0, 1, or 2.
#endif
shadowColor = mix(skyColor, fogColor, rainStrength);

if (sunset > 0.01) {
	vec4 sunsetColor = vec4(clamp(sunsetColorForOtherThings - adjustedTime, 0.0, 1.0), sunset); //color of sunset gradient at the horizon, and mix level
	if (rainStrength > 0.001) sunsetColor.rgb = mix(sunsetColor.rgb, fogColor * (1.0 - rainStrength * 0.5), rainStrength * 0.625); //reduce redness intensity when raining
	skyLightColor  = mix(skyLightColor, sunsetColor.rgb, sunsetColor.a);
	shadowColor    = mix(shadowColor,   sunsetColor.rgb, sunsetColor.a);
}