/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ChainConveyorRenderer
extends KineticBlockEntityRenderer<ChainConveyorBlockEntity> {
    public static final ResourceLocation CHAIN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/block/chain.png");
    public static final int MIP_DISTANCE_SQR = 2304;

    public ChainConveyorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(ChainConveyorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        BlockPos pos = be.getBlockPos();
        FrustumIntersection frustum = null;
        Vec3 camPos = null;
        if (Minecraft.getInstance().level == be.getLevel()) {
            frustum = this.getFrustumIntersection();
            camPos = Minecraft.getInstance().getBlockEntityRenderDispatcher().camera.getPosition();
        }
        boolean renderCentre = frustum == null || frustum.testAab((float)(pos.getX() - 2) - (float)camPos.x, (float)pos.getY() - (float)camPos.y, (float)(pos.getZ() - 2) - (float)camPos.z, (float)(pos.getX() + 2) - (float)camPos.x, (float)(pos.getY() + 1) - (float)camPos.y, (float)(pos.getZ() + 2) - (float)camPos.z);
        this.renderChains(be, ms, buffer, light, overlay, frustum, camPos, renderCentre);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        if (renderCentre) {
            CachedBuffers.partial((PartialModel)AllPartialModels.CHAIN_CONVEYOR_WHEEL, (BlockState)be.getBlockState()).light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        }
        for (ChainConveyorPackage chainConveyorPackage : be.loopingPackages) {
            this.renderBox(be, ms, buffer, overlay, pos, chainConveyorPackage, partialTicks, frustum, camPos);
        }
        for (Map.Entry entry : be.travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.renderBox(be, ms, buffer, overlay, pos, box, partialTicks, frustum, camPos);
            }
        }
    }

    private void renderBox(ChainConveyorBlockEntity be, PoseStack ms, MultiBufferSource buffer, int overlay, BlockPos pos, ChainConveyorPackage box, float partialTicks, FrustumIntersection frustum, Vec3 camPos) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.isEmpty()) {
            return;
        }
        ChainConveyorPackage.ChainConveyorPackagePhysicsData physicsData = box.physicsData((LevelAccessor)be.getLevel());
        if (physicsData.prevPos == null) {
            return;
        }
        Vec3 position = physicsData.prevPos.lerp(physicsData.pos, (double)partialTicks);
        Vec3 targetPosition = physicsData.prevTargetPos.lerp(physicsData.targetPos, (double)partialTicks);
        if (frustum != null && !frustum.testSphere((float)(targetPosition.x - camPos.x), (float)(targetPosition.y - camPos.y), (float)(targetPosition.z - camPos.z), 1.0f)) {
            return;
        }
        float yaw = AngleHelper.angleLerp((double)partialTicks, (double)physicsData.prevYaw, (double)physicsData.yaw);
        Vec3 offset = new Vec3(targetPosition.x - (double)pos.getX(), targetPosition.y - (double)pos.getY(), targetPosition.z - (double)pos.getZ());
        BlockPos containingPos = BlockPos.containing((Position)position);
        Level level = be.getLevel();
        BlockState blockState = be.getBlockState();
        int light = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, containingPos), (int)level.getBrightness(LightLayer.SKY, containingPos));
        if (physicsData.modelKey == null) {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)box.item.getItem());
            if (key == BuiltInRegistries.ITEM.getDefaultKey()) {
                return;
            }
            physicsData.modelKey = key;
        }
        SuperByteBuffer rigBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), (BlockState)blockState);
        SuperByteBuffer boxBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.PACKAGES.get(physicsData.modelKey), (BlockState)blockState);
        Vec3 dangleDiff = VecHelper.rotate((Vec3)targetPosition.add(0.0, 0.5, 0.0).subtract(position), (double)(-yaw), (Direction.Axis)Direction.Axis.Y);
        float zRot = Mth.wrapDegrees((float)((float)Mth.atan2((double)(-dangleDiff.x), (double)dangleDiff.y) * 57.295776f)) / 2.0f;
        float xRot = Mth.wrapDegrees((float)((float)Mth.atan2((double)dangleDiff.z, (double)dangleDiff.y) * 57.295776f)) / 2.0f;
        zRot = Mth.clamp((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = Mth.clamp((float)xRot, (float)-25.0f, (float)25.0f);
        for (SuperByteBuffer buf : new SuperByteBuffer[]{rigBuffer, boxBuffer}) {
            buf.translate(offset);
            buf.translate(0.0f, 0.625f, 0.0f);
            buf.rotateYDegrees(yaw);
            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateYDegrees(180.0f);
            }
            buf.uncenter();
            buf.translate(0.0f, -PackageItem.getHookDistance(box.item) + 0.4375f, 0.0f);
            buf.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        }
    }

    private static int calculateLineCircleIntersection(Vec3 start, Vec3 end, Vec3 cameraPos, Vec3[] intersections) {
        float c;
        Vec3 ab = end.subtract(start);
        Vec3 ac = start.subtract(cameraPos);
        float a = (float)ab.lengthSqr();
        float b = 2.0f * (float)ac.dot(ab);
        float discriminant = b * b - 4.0f * a * (c = (float)ac.lengthSqr() - 2304.0f);
        if (discriminant < 0.0f) {
            return 0;
        }
        float sqrtDisc = Mth.sqrt((float)discriminant);
        float t1 = (-b - sqrtDisc) / (2.0f * a);
        float t2 = (-b + sqrtDisc) / (2.0f * a);
        int count = 0;
        if (t1 >= 0.0f && t1 <= 1.0f) {
            intersections[count++] = start.add(ab.scale((double)t1));
        }
        if (t2 >= 0.0f && t2 <= 1.0f && Math.abs(t2 - t1) > 1.0E-6f) {
            intersections[count++] = start.add(ab.scale((double)t2));
        }
        return count;
    }

    public static Vector3f calculateLODCut(Vec3 start, Vec3 end, Vec3 cameraPos) {
        Vec3[] intersections = new Vec3[2];
        int intersectionCount = ChainConveyorRenderer.calculateLineCircleIntersection(start, end, cameraPos, intersections);
        float totalLength = (float)start.distanceTo(end);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (intersectionCount == 0) {
            if (start.distanceToSqr(cameraPos) < 2304.0 && end.distanceToSqr(cameraPos) < 2304.0) {
                y = totalLength;
            } else {
                x = totalLength;
            }
        } else if (intersectionCount == 1) {
            boolean endInside;
            boolean bl = endInside = end.distanceToSqr(cameraPos) < 2304.0;
            if (endInside) {
                x = (float)start.distanceTo(intersections[0]);
                y = (float)intersections[0].distanceTo(end);
                z = 0.0f;
            } else {
                x = 0.0f;
                y = (float)start.distanceTo(intersections[0]);
                z = (float)intersections[0].distanceTo(end);
            }
        } else if (intersectionCount == 2) {
            x = (float)start.distanceTo(intersections[0]);
            y = (float)intersections[0].distanceTo(intersections[1]);
            z = (float)end.distanceTo(intersections[1]);
        }
        return new Vector3f(x, y, z);
    }

    private void renderChains(ChainConveyorBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay, FrustumIntersection frustum, Vec3 camPos, boolean renderCentre) {
        if (frustum != null) {
            float renderDistance = Minecraft.getInstance().gameRenderer.getRenderDistance();
            if (camPos.distanceToSqr(be.getBlockPos().getCenter()) > (double)(renderDistance * renderDistance)) {
                return;
            }
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) / (360.0f / Math.abs(be.getSpeed()));
        if ((time %= 1.0f) < 0.0f) {
            time += 1.0f;
        }
        float animation = time - 0.5f;
        for (BlockPos blockPos : be.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null) continue;
            Level level = be.getLevel();
            BlockPos tilePos = be.getBlockPos();
            BlockPos targetPos = tilePos.offset((Vec3i)blockPos);
            Vec3 start = stats.start();
            Vec3 end = stats.end();
            Vec3 diff = end.subtract(start);
            double yaw = 57.2957763671875 * Mth.atan2((double)diff.x, (double)diff.z);
            if (!VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel()) && renderCentre) {
                SuperByteBuffer guard = CachedBuffers.partial((PartialModel)AllPartialModels.CHAIN_CONVEYOR_GUARD, (BlockState)be.getBlockState());
                guard.center();
                guard.rotateYDegrees((float)yaw);
                guard.uncenter();
                guard.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
            }
            if (frustum == null || frustum.testLineSegment((float)(start.x - camPos.x), (float)(start.y - camPos.y), (float)(start.z - camPos.z), (float)(end.x - camPos.x), (float)(end.y - camPos.y), (float)(end.z - camPos.z))) {
                double pitch = 57.2957763671875 * Mth.atan2((double)diff.y, (double)diff.multiply(1.0, 0.0, 1.0).length());
                int light1 = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, tilePos), (int)level.getBrightness(LightLayer.SKY, tilePos));
                int light2 = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, targetPos), (int)level.getBrightness(LightLayer.SKY, targetPos));
                Vec3 startOffset = start.subtract(Vec3.atCenterOf((Vec3i)tilePos));
                ms.pushPose();
                PoseTransformStack chain = TransformStack.of((PoseStack)ms);
                chain.center();
                chain.translate(startOffset);
                chain.rotateYDegrees((float)yaw);
                chain.rotateXDegrees(90.0f - (float)pitch);
                chain.rotateYDegrees(45.0f);
                chain.translate(0.0f, 0.5f, 0.0f);
                chain.uncenter();
                if (frustum != null) {
                    ChainConveyorRenderer.renderChainWithLod(ms, buffer, animation, light1, light2, camPos, start, end, (TransformStack)chain);
                } else {
                    ChainConveyorRenderer.renderChain(ms, buffer, animation, 0.0f, stats.chainLength(), light1, light2, false);
                }
                ms.popPose();
            }
            if (frustum == null) continue;
            float renderDistance = Minecraft.getInstance().gameRenderer.getRenderDistance();
            if (camPos.distanceToSqr(targetPos.getCenter()) <= (double)(renderDistance * renderDistance)) continue;
            boolean reversed = be.getSpeed() < 0.0f;
            ChainConveyorBlockEntity.ConnectionStats virtualStats = ChainConveyorBlockEntity.calculateConnectionStats(blockPos.multiply(-1), targetPos, reversed);
            start = virtualStats.start();
            end = virtualStats.end();
            if (!frustum.testLineSegment((float)(start.x - camPos.x), (float)(start.y - camPos.y), (float)(start.z - camPos.z), (float)(end.x - camPos.x), (float)(end.y - camPos.y), (float)(end.z - camPos.z))) continue;
            diff = end.subtract(start);
            yaw = 57.2957763671875 * Mth.atan2((double)diff.x, (double)diff.z);
            double pitch = 57.2957763671875 * Mth.atan2((double)diff.y, (double)diff.multiply(1.0, 0.0, 1.0).length());
            Vec3 startOffset = start.subtract(Vec3.atCenterOf((Vec3i)tilePos));
            ms.pushPose();
            PoseTransformStack chain = TransformStack.of((PoseStack)ms);
            chain.center();
            chain.translate(startOffset);
            chain.rotateYDegrees((float)yaw);
            chain.rotateXDegrees(90.0f - (float)pitch);
            chain.rotateYDegrees(45.0f);
            chain.translate(0.0f, 0.5f, 0.0f);
            chain.uncenter();
            int light1 = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, tilePos), (int)level.getBrightness(LightLayer.SKY, tilePos));
            ChainConveyorRenderer.renderChainWithLod(ms, buffer, animation, light1, light1, camPos, start, end, (TransformStack)chain);
            ms.popPose();
        }
    }

    public static void renderChainWithLod(PoseStack ms, MultiBufferSource buffer, float animation, int light1, int light2, Vec3 camPos, Vec3 chainStart, Vec3 chainEnd, TransformStack chain) {
        Vector3f length = ChainConveyorRenderer.calculateLODCut(chainStart, chainEnd, camPos);
        if (length.x > 1.0E-6f) {
            ChainConveyorRenderer.renderChain(ms, buffer, animation, 0.0f, length.x, light1, light2, true);
        }
        if (length.y > 1.0E-6f) {
            chain.translate(0.0f, length.x, 0.0f);
            ChainConveyorRenderer.renderChain(ms, buffer, animation, length.x, length.y, light1, light2, false);
        }
        if (length.z > 1.0E-6f) {
            chain.translate(0.0f, length.y, 0.0f);
            ChainConveyorRenderer.renderChain(ms, buffer, animation, 0.0f, length.z, light1, light2, true);
        }
    }

    public static void renderChain(PoseStack ms, MultiBufferSource buffer, float animation, float start, float length, int light1, int light2, boolean far) {
        float radius = far ? 0.0625f : 0.09375f;
        float maxV = far ? 0.0f : animation - start;
        float minV = far ? 0.0625f : maxV - length;
        float minU = far ? 0.1875f : 0.0f;
        float maxU = far ? 0.25f : 0.1875f;
        ms.pushPose();
        ms.translate(0.5, 0.0, 0.5);
        VertexConsumer vc = buffer.getBuffer(RenderTypes.chain(CHAIN_LOCATION));
        ChainConveyorRenderer.renderPart(ms, vc, length, 0.0f, radius, radius, 0.0f, -radius, 0.0f, 0.0f, -radius, minU, maxU, minV, maxV, light1, light2, far);
        ms.popPose();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, boolean far) {
        PoseStack.Pose posestack$pose = pPoseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        float uO = far ? 0.0f : 0.1875f;
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.addVertex(pPose, pX, pY, pZ).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pNormal, 0.0f, 1.0f, 0.0f);
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(ChainConveyorBlockEntity be) {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, BlockState state) {
        return CachedBuffers.partial((PartialModel)AllPartialModels.CHAIN_CONVEYOR_SHAFT, (BlockState)state);
    }

    @Override
    protected RenderType getRenderType(ChainConveyorBlockEntity be, BlockState state) {
        return RenderType.cutoutMipped();
    }
}

