/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.part.InstanceTree;
import dev.engine_room.flywheel.lib.model.part.ModelTree;
import dev.engine_room.flywheel.lib.model.part.ModelTrees;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class MinecartVisual<T extends AbstractMinecart>
extends AbstractEntityVisual<T>
implements SimpleTickableVisual,
SimpleDynamicVisual {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/minecart.png");
    private static final Material MATERIAL = SimpleMaterial.builder().texture(TEXTURE).mipmap(false).build();
    private final InstanceTree instances;
    @Nullable
    private TransformedInstance contents;
    private final Matrix4fStack stack = new Matrix4fStack(2);
    private BlockState blockState;

    public MinecartVisual(VisualizationContext ctx, T entity, float partialTick, ModelLayerLocation layerLocation) {
        super(ctx, entity, partialTick);
        this.instances = InstanceTree.create((InstancerProvider)this.instancerProvider(), (ModelTree)ModelTrees.of((ModelLayerLocation)layerLocation, (Material)MATERIAL));
        this.blockState = entity.getDisplayBlockState();
        this.contents = this.createContentsInstance();
        this.updateInstances(partialTick);
        this.updateLight(partialTick);
    }

    @Nullable
    private TransformedInstance createContentsInstance() {
        RenderShape shape = this.blockState.getRenderShape();
        if (shape == RenderShape.ENTITYBLOCK_ANIMATED) {
            this.instances.visible(false);
            return null;
        }
        if (shape == RenderShape.INVISIBLE) {
            return null;
        }
        return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block((BlockState)this.blockState)).createInstance();
    }

    public void tick(TickableVisual.Context context) {
        BlockState displayBlockState = ((AbstractMinecart)this.entity).getDisplayBlockState();
        if (displayBlockState != this.blockState) {
            this.blockState = displayBlockState;
            if (this.contents != null) {
                this.contents.delete();
            }
            this.contents = this.createContentsInstance();
        }
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (!this.isVisible(context.frustum())) {
            return;
        }
        if (!this.instances.visible()) {
            return;
        }
        this.updateInstances(context.partialTick());
    }

    private void updateInstances(float partialTick) {
        this.stack.identity();
        double posX = Mth.lerp((double)partialTick, (double)((AbstractMinecart)this.entity).xOld, (double)((AbstractMinecart)this.entity).getX());
        double posY = Mth.lerp((double)partialTick, (double)((AbstractMinecart)this.entity).yOld, (double)((AbstractMinecart)this.entity).getY());
        double posZ = Mth.lerp((double)partialTick, (double)((AbstractMinecart)this.entity).zOld, (double)((AbstractMinecart)this.entity).getZ());
        Vec3i renderOrigin = this.renderOrigin();
        this.stack.translate((float)(posX - (double)renderOrigin.getX()), (float)(posY - (double)renderOrigin.getY()), (float)(posZ - (double)renderOrigin.getZ()));
        float yaw = Mth.lerp((float)partialTick, (float)((AbstractMinecart)this.entity).yRotO, (float)((AbstractMinecart)this.entity).getYRot());
        long randomBits = (long)((AbstractMinecart)this.entity).getId() * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float nudgeX = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float nudgeY = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float nudgeZ = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        this.stack.translate(nudgeX, nudgeY, nudgeZ);
        Vec3 pos = ((AbstractMinecart)this.entity).getPos(posX, posY, posZ);
        float pitch = Mth.lerp((float)partialTick, (float)((AbstractMinecart)this.entity).xRotO, (float)((AbstractMinecart)this.entity).getXRot());
        if (pos != null) {
            Vec3 offset1 = ((AbstractMinecart)this.entity).getPosOffs(posX, posY, posZ, (double)0.3f);
            Vec3 offset2 = ((AbstractMinecart)this.entity).getPosOffs(posX, posY, posZ, (double)-0.3f);
            if (offset1 == null) {
                offset1 = pos;
            }
            if (offset2 == null) {
                offset2 = pos;
            }
            this.stack.translate((float)(pos.x - posX), (float)((offset1.y + offset2.y) / 2.0 - posY), (float)(pos.z - posZ));
            Vec3 vec = offset2.add(-offset1.x, -offset1.y, -offset1.z);
            if (vec.length() != 0.0) {
                vec = vec.normalize();
                yaw = (float)(Math.atan2(vec.z, vec.x) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vec.y) * 73.0);
            }
        }
        this.stack.translate(0.0f, 0.375f, 0.0f);
        this.stack.rotateY((180.0f - yaw) * ((float)Math.PI / 180));
        this.stack.rotateZ(-pitch * ((float)Math.PI / 180));
        float hurtTime = (float)((AbstractMinecart)this.entity).getHurtTime() - partialTick;
        float damage = ((AbstractMinecart)this.entity).getDamage() - partialTick;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            this.stack.rotateX(Mth.sin((float)hurtTime) * hurtTime * damage / 10.0f * (float)((AbstractMinecart)this.entity).getHurtDir() * ((float)Math.PI / 180));
        }
        if (this.contents != null) {
            int displayOffset = ((AbstractMinecart)this.entity).getDisplayOffset();
            this.stack.pushMatrix();
            this.stack.scale(0.75f, 0.75f, 0.75f);
            this.stack.translate(-0.5f, (float)(displayOffset - 8) / 16.0f, 0.5f);
            this.stack.rotateY(1.5707964f);
            this.updateContents(this.contents, (Matrix4f)this.stack, partialTick);
            this.stack.popMatrix();
        }
        this.stack.scale(-1.0f, -1.0f, 1.0f);
        this.instances.updateInstances((Matrix4fc)this.stack);
        this.updateLight(partialTick);
    }

    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        contents.setTransform((Matrix4fc)pose).setChanged();
    }

    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight(partialTick);
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
        FlatLit.relight((int)packedLight, (FlatLit[])new FlatLit[]{this.contents});
    }

    protected void _delete() {
        this.instances.delete();
        if (this.contents != null) {
            this.contents.delete();
        }
    }

    public static boolean shouldSkipRender(AbstractMinecart minecart) {
        return minecart.getDisplayBlockState().getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

