/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.util.InstanceRecycler;
import dev.engine_room.vanillin.item.ItemModels;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import org.joml.Vector3fc;

public class ItemVisual
extends AbstractEntityVisual<ItemEntity>
implements SimpleDynamicVisual {
    private static final ThreadLocal<RandomSource> RANDOM = ThreadLocal.withInitial(RandomSource::createNewThreadLocalInstance);
    private final PoseStack pPoseStack = new PoseStack();
    private BakedModel bakedModel;
    private ItemStack currentStack;
    private InstanceRecycler<TransformedInstance> instances;

    public ItemVisual(VisualizationContext ctx, ItemEntity entity, float partialTick) {
        super(ctx, (Entity)entity, partialTick);
        this.currentStack = entity.getItem();
        this.bakedModel = ItemModels.getModel(this.currentStack);
        Model model = ItemModels.get(this.level, this.currentStack, ItemDisplayContext.GROUND);
        this.instances = new InstanceRecycler(() -> (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance());
        this.animate(partialTick);
    }

    public static boolean isSupported(ItemEntity entity) {
        return ItemModels.isSupported(entity.getItem());
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum())) {
            this.instances.resetCount();
            this.instances.discardExtra();
            return;
        }
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTick) {
        this.pPoseStack.setIdentity();
        TransformStack.of((PoseStack)this.pPoseStack).translate((Vector3fc)this.getVisualPosition(partialTick));
        ItemStack itemstack = ((ItemEntity)this.entity).getItem();
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)this.currentStack)) {
            this.instances.delete();
            this.currentStack = itemstack.copy();
            this.bakedModel = ItemModels.getModel(this.currentStack);
            Model model = ItemModels.get(this.level, this.currentStack, ItemDisplayContext.GROUND);
            this.instances = new InstanceRecycler(() -> (TransformedInstance)this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance());
        }
        this.instances.resetCount();
        int i = itemstack.isEmpty() ? 187 : Item.getId((Item)itemstack.getItem()) + itemstack.getDamageValue();
        RandomSource random = RANDOM.get();
        random.setSeed((long)i);
        boolean flag = this.bakedModel.isGui3d();
        int j = this.getRenderAmount(itemstack);
        float f = 0.25f;
        float f1 = this.shouldBob() ? Mth.sin((float)(((float)((ItemEntity)this.entity).getAge() + partialTick) / 10.0f + ((ItemEntity)this.entity).bobOffs)) * 0.1f + 0.1f : 0.0f;
        float groundScaleX = this.bakedModel.getTransforms().ground.scale.y();
        float groundScaleY = this.bakedModel.getTransforms().ground.scale.y();
        float groundScaleZ = this.bakedModel.getTransforms().ground.scale.y();
        this.pPoseStack.translate(0.0f, f1 + 0.25f * groundScaleZ, 0.0f);
        float f3 = ((ItemEntity)this.entity).getSpin(partialTick);
        this.pPoseStack.mulPose(Axis.YP.rotation(f3));
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f * groundScaleX;
            float f8 = -0.0f * (float)(j - 1) * 0.5f * groundScaleY;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f * groundScaleZ;
            this.pPoseStack.translate(f7, f8, f9);
        }
        int light = LightTexture.pack((int)this.level.getBrightness(LightLayer.BLOCK, ((ItemEntity)this.entity).blockPosition()), (int)this.level.getBrightness(LightLayer.SKY, ((ItemEntity)this.entity).blockPosition()));
        for (int k = 0; k < j; ++k) {
            this.pPoseStack.pushPose();
            if (k > 0) {
                if (flag) {
                    float f11 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f13 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f10 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    this.pPoseStack.translate(this.shouldSpreadItems() ? f11 : 0.0f, this.shouldSpreadItems() ? f13 : 0.0f, this.shouldSpreadItems() ? f10 : 0.0f);
                } else {
                    float f12 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f14 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    this.pPoseStack.translate(this.shouldSpreadItems() ? (double)f12 : 0.0, this.shouldSpreadItems() ? (double)f14 : 0.0, 0.0);
                }
            }
            ((TransformedInstance)this.instances.get()).setTransform(this.pPoseStack.last()).light(light).setChanged();
            this.pPoseStack.popPose();
            if (flag) continue;
            this.pPoseStack.translate(0.0, 0.0, (double)(0.09375f * groundScaleZ));
        }
        this.instances.discardExtra();
    }

    protected int getRenderAmount(ItemStack pStack) {
        int i = 1;
        if (pStack.getCount() > 48) {
            i = 5;
        } else if (pStack.getCount() > 32) {
            i = 4;
        } else if (pStack.getCount() > 16) {
            i = 3;
        } else if (pStack.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }

    protected void _delete() {
        this.instances.delete();
    }
}

