/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.EntityVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.vanillin.item.ItemModels;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LightLayer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ItemFrameVisual
extends AbstractVisual
implements EntityVisual<ItemFrame>,
SimpleDynamicVisual {
    private static final ModelResourceLocation FRAME_LOCATION = ModelResourceLocation.vanilla((String)"item_frame", (String)"map=false");
    private static final ModelResourceLocation MAP_FRAME_LOCATION = ModelResourceLocation.vanilla((String)"item_frame", (String)"map=true");
    private static final ModelResourceLocation GLOW_FRAME_LOCATION = ModelResourceLocation.vanilla((String)"glow_item_frame", (String)"map=false");
    private static final ModelResourceLocation GLOW_MAP_FRAME_LOCATION = ModelResourceLocation.vanilla((String)"glow_item_frame", (String)"map=true");
    public static final RendererReloadCache<ModelResourceLocation, Model> MODEL_RESOURCE_LOCATION = new RendererReloadCache(mrl -> {
        ModelManager modelManager = Minecraft.getInstance().getModelManager().getBlockModelShaper().getModelManager();
        return new BakedModelBuilder(modelManager.getModel(mrl)).build();
    });
    private final Matrix4f baseTransform = new Matrix4f();
    private final TransformedInstance frame;
    private final TransformedInstance item;
    private final ItemFrame entity;
    private ModelResourceLocation lastFrameLocation;
    private ItemStack lastItemStack;

    public ItemFrameVisual(VisualizationContext ctx, ItemFrame entity, float partialTick) {
        super(ctx, entity.level(), partialTick);
        this.entity = entity;
        this.lastItemStack = entity.getItem().copy();
        this.lastFrameLocation = ItemFrameVisual.getFrameModelResourceLoc(entity, this.lastItemStack);
        Model frameModel = (Model)MODEL_RESOURCE_LOCATION.get((Object)this.lastFrameLocation);
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, frameModel).createInstance();
        this.frame.setTransform((Matrix4fc)this.baseTransform);
        this.item = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, ItemDisplayContext.FIXED)).createInstance();
        this.animate(partialTick);
    }

    public static boolean shouldVisualize(ItemFrame entity) {
        return !entity.getItem().is(Items.FILLED_MAP) && ItemModels.isSupported(entity.getItem());
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        int light = LightTexture.pack((int)this.getBlockLightLevel(this.entity.getPos()), (int)this.getSkyLightLevel(this.entity.getPos()));
        boolean invisible = this.entity.isInvisible();
        Direction direction = this.entity.getDirection();
        Vec3i origin = this.visualizationContext.renderOrigin();
        float d = 0.46875f;
        float x = (float)(this.entity.getX() - (double)origin.getX() + (double)((float)direction.getStepX() * d));
        float y = (float)(this.entity.getY() - (double)origin.getY() + (double)((float)direction.getStepY() * d));
        float z = (float)(this.entity.getZ() - (double)origin.getZ() + (double)((float)direction.getStepZ() * d));
        this.baseTransform.translation(x, y, z);
        this.baseTransform.rotateXYZ((float)Math.PI / 180 * this.entity.getXRot(), (float)Math.PI / 180 * (180.0f - this.entity.getYRot()), 0.0f);
        ItemStack stack = this.entity.getItem();
        ModelResourceLocation frameLocation = ItemFrameVisual.getFrameModelResourceLoc(this.entity, stack);
        if (frameLocation != this.lastFrameLocation) {
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, (Model)MODEL_RESOURCE_LOCATION.get((Object)frameLocation)).stealInstance((Instance)this.frame);
            this.lastFrameLocation = frameLocation;
        }
        this.frame.setVisible(!invisible);
        this.frame.setTransform((Matrix4fc)this.baseTransform).translate(-0.5f, -0.5f, -0.5f).light(light).setChanged();
        if (!ItemStack.matches((ItemStack)this.lastItemStack, (ItemStack)stack)) {
            this.lastItemStack = stack.copy();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, ItemDisplayContext.FIXED)).stealInstance((Instance)this.item);
        }
        this.item.setTransform((Matrix4fc)this.baseTransform);
        if (invisible) {
            this.item.translate(0.0f, 0.0f, 0.5f);
        } else {
            this.item.translate(0.0f, 0.0f, 0.4375f);
        }
        int i = this.entity.hasFramedMap() ? this.entity.getRotation() % 4 * 2 : this.entity.getRotation();
        this.item.rotateZDegrees((float)i * 360.0f / 8.0f);
        this.item.scale(0.5f, 0.5f, 0.5f);
        this.item.light(this.getLightVal(0xF000F0, light)).setChanged();
    }

    public void update(float partialTick) {
    }

    protected void _delete() {
        this.frame.delete();
        this.item.delete();
    }

    private int getLightVal(int glowLightVal, int regularLightVal) {
        return this.entity.getType() == EntityType.GLOW_ITEM_FRAME ? glowLightVal : regularLightVal;
    }

    protected int getSkyLightLevel(BlockPos pos) {
        return this.level.getBrightness(LightLayer.SKY, pos);
    }

    protected int getBlockLightLevelBase(BlockPos pos) {
        return this.entity.isOnFire() ? 15 : this.level.getBrightness(LightLayer.BLOCK, pos);
    }

    protected int getBlockLightLevel(BlockPos pos) {
        return this.entity.getType() == EntityType.GLOW_ITEM_FRAME ? Math.max(5, this.getBlockLightLevelBase(pos)) : this.getBlockLightLevelBase(pos);
    }

    public static ModelResourceLocation getFrameModelResourceLoc(ItemFrame entity, ItemStack item) {
        boolean bl;
        boolean bl2 = bl = entity.getType() == EntityType.GLOW_ITEM_FRAME;
        if (item.is(Items.FILLED_MAP)) {
            return bl ? GLOW_MAP_FRAME_LOCATION : MAP_FRAME_LOCATION;
        }
        return bl ? GLOW_FRAME_LOCATION : FRAME_LOCATION;
    }
}

