/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.item;

import dev.engine_room.vanillin.VanillinXplat;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class SodiumAnimatedTextureCompat {
    private static final ReferenceSet<TextureAtlasSprite> VISIBLE = ReferenceSets.synchronize((ReferenceSet)new ReferenceArraySet());
    private static final boolean IS_SODIUM_LOADED = VanillinXplat.INSTANCE.isModLoaded("sodium");

    public static void add(TextureAtlasSprite sprite) {
        if (IS_SODIUM_LOADED) {
            Internals.add(sprite);
        }
    }

    public static void beginFrame() {
        if (IS_SODIUM_LOADED) {
            Internals.beginFrame();
        }
    }

    public static void onReloadRenderer() {
        VISIBLE.clear();
    }

    private static final class Internals {
        private Internals() {
        }

        private static void add(TextureAtlasSprite sprite) {
            if (SpriteUtil.hasAnimation((TextureAtlasSprite)sprite)) {
                VISIBLE.add((Object)sprite);
            }
        }

        private static void beginFrame() {
            for (TextureAtlasSprite sprite : VISIBLE) {
                SpriteUtil.markSpriteActive((TextureAtlasSprite)sprite);
            }
        }
    }
}

