/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.item;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.vertex.VertexList;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.SingleMeshModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.vertex.FullVertexView;
import dev.engine_room.vanillin.Vanillin;
import dev.engine_room.vanillin.VanillinXplat;
import dev.engine_room.vanillin.item.SodiumAnimatedTextureCompat;
import dev.engine_room.vanillin.mixin.item.ItemOverridesAccessor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ItemModels {
    public static final TagKey<Item> NO_INSTANCING = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Vanillin.rl("no_instancing"));
    private static final Model EMPTY_MODEL = new SimpleModel(List.of());
    private static final RendererReloadCache<BakedMeshKey, Mesh> MESH_CACHE = new RendererReloadCache(key -> ItemModels.bakeMesh(key.model(), key.displayContext()));
    private static final RendererReloadCache<BakedModelKey, Model> MODEL_CACHE = new RendererReloadCache(key -> ItemModels.bakeModel(key.model(), key.displayContext(), key.material(), key.foil()));
    private static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.vanilla((String)"trident", (String)"inventory");
    private static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.vanilla((String)"spyglass", (String)"inventory");
    @Nullable
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};
    private static final Set<ResourceLocation> ALLOWED_OVERRIDES = new HashSet<ResourceLocation>();

    public static boolean isSupported(ItemStack stack) {
        return !stack.is(NO_INSTANCING) && ItemModels.doesNotHaveItemColors(stack.getItem()) && ItemModels.isSupported(ItemModels.getModel(stack));
    }

    private static boolean doesNotHaveItemColors(Item item) {
        return VanillinXplat.INSTANCE.itemColors(item) == null;
    }

    public static BakedModel getModel(ItemStack stack) {
        return Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(stack);
    }

    @Nullable
    public static BakedModel getActualBakedModel(@Nullable ClientLevel clientLevel, ItemStack itemStack, ItemDisplayContext displayContext) {
        boolean notEquipped;
        if (itemStack.isEmpty()) {
            return null;
        }
        BakedModel baseModel = ItemModels.getModel(itemStack);
        ItemOverrides overrides = baseModel.getOverrides();
        BakedModel model = overrides.resolve(baseModel, itemStack, clientLevel, null, 0);
        if (model == null) {
            model = baseModel;
        }
        boolean bl = notEquipped = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED;
        if (model.isCustomRenderer() || itemStack.is(Items.TRIDENT) && !notEquipped) {
            return null;
        }
        if (notEquipped) {
            if (itemStack.is(Items.TRIDENT)) {
                model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager().getModel(TRIDENT_MODEL);
            } else if (itemStack.is(Items.SPYGLASS)) {
                model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager().getModel(SPYGLASS_MODEL);
            }
        }
        return model;
    }

    public static boolean isSupported(BakedModel model) {
        Class c;
        if (model.isCustomRenderer()) {
            return false;
        }
        ItemOverrides overrides = model.getOverrides();
        if (overrides != ItemOverrides.EMPTY) {
            ResourceLocation[] properties;
            for (ResourceLocation property : properties = ((ItemOverridesAccessor)overrides).vanillin$properties()) {
                if (ALLOWED_OVERRIDES.contains(property)) continue;
                return false;
            }
        }
        return (c = model.getClass()) == SimpleBakedModel.class || c == MultiPartBakedModel.class || c == WeightedBakedModel.class;
    }

    public static Model get(Level level, ItemStack itemStack, ItemDisplayContext displayContext) {
        ClientLevel clientLevel;
        BakedModel model;
        BlockItem block;
        Item item;
        boolean cull = displayContext == ItemDisplayContext.GUI || displayContext.firstPerson() || !((item = itemStack.getItem()) instanceof BlockItem) || !((block = (BlockItem)item).getBlock() instanceof HalfTransparentBlock) && !(block.getBlock() instanceof StainedGlassPaneBlock);
        Material material = ModelUtil.getItemMaterial((RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)itemStack, (boolean)cull));
        if (material == null) {
            material = Materials.TRANSLUCENT_ENTITY;
        }
        if (itemStack.getItem() instanceof BlockItem && material.transparency() == Transparency.TRANSLUCENT) {
            material = SimpleMaterial.builderOf((Material)material).transparency(Transparency.ORDER_INDEPENDENT).build();
        }
        if ((model = ItemModels.getActualBakedModel(clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null, itemStack, displayContext)) == null) {
            return EMPTY_MODEL;
        }
        return (Model)MODEL_CACHE.get((Object)new BakedModelKey(model, displayContext, material, itemStack.hasFoil()));
    }

    public static Model bakeModel(BakedModel model, ItemDisplayContext displayContext, Material material, boolean foil) {
        Mesh mesh = (Mesh)MESH_CACHE.get((Object)new BakedMeshKey(model, displayContext));
        if (foil) {
            return new SimpleModel(List.of(new Model.ConfiguredMesh(material, mesh), new Model.ConfiguredMesh(Materials.GLINT, mesh)));
        }
        return new SingleMeshModel(mesh, material);
    }

    public static Mesh bakeMesh(BakedModel model, ItemDisplayContext displayContext) {
        boolean leftHand = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        PoseStack poseStack = new PoseStack();
        model.getTransforms().getTransform(displayContext).apply(leftHand, poseStack);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        RandomSource randomSource = RandomSource.create();
        ArrayList allQuads = new ArrayList();
        for (Direction value : DIRECTIONS) {
            randomSource.setSeed(42L);
            allQuads.addAll(model.getQuads(null, value, randomSource));
        }
        int vertexCount = allQuads.size() * 4;
        MemoryBlock memoryBlock = MemoryBlock.mallocTracked((long)((long)vertexCount * 36L));
        FullVertexView meshVertices = new FullVertexView();
        meshVertices.nativeMemoryOwner((Object)memoryBlock);
        meshVertices.ptr(memoryBlock.ptr());
        meshVertices.vertexCount(vertexCount);
        Vector4f position = new Vector4f();
        Vector3f normal = new Vector3f();
        Matrix4f poseMatrix = poseStack.last().pose();
        Matrix3f normalMatrix = poseStack.last().normal();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            int vertex = 0;
            for (BakedQuad quad : allQuads) {
                SodiumAnimatedTextureCompat.add(quad.getSprite());
                int[] js = quad.getVertices();
                Direction direction = quad.getDirection();
                normal.set((float)direction.getStepX(), (float)direction.getStepY(), (float)direction.getStepZ());
                normal.mul((Matrix3fc)normalMatrix);
                int j = js.length / 8;
                for (int k = 0; k < j; ++k) {
                    intBuffer.clear();
                    intBuffer.put(js, k * 8, 8);
                    position.set(byteBuffer.getFloat(0), byteBuffer.getFloat(4), byteBuffer.getFloat(8), 1.0f);
                    position.mul((Matrix4fc)poseMatrix);
                    meshVertices.x(vertex, position.x());
                    meshVertices.y(vertex, position.y());
                    meshVertices.z(vertex, position.z());
                    meshVertices.r(vertex, 1.0f);
                    meshVertices.g(vertex, 1.0f);
                    meshVertices.b(vertex, 1.0f);
                    meshVertices.a(vertex, 1.0f);
                    meshVertices.u(vertex, byteBuffer.getFloat(16));
                    meshVertices.v(vertex, byteBuffer.getFloat(20));
                    meshVertices.overlay(vertex, OverlayTexture.NO_OVERLAY);
                    meshVertices.light(vertex, 0);
                    meshVertices.normalX(vertex, normal.x());
                    meshVertices.normalY(vertex, normal.y());
                    meshVertices.normalZ(vertex, normal.z());
                    ++vertex;
                }
            }
        }
        return new SimpleQuadMesh((VertexList)meshVertices);
    }

    static {
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"lefthanded"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"cooldown"));
        ALLOWED_OVERRIDES.add(ItemModelGenerators.TRIM_TYPE_PREDICATE_ID);
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"custom_model_data"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"pull"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"brushing"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"pulling"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"filled"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"charged"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"firework"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"broken"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"cast"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"blocking"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"throwing"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"level"));
        ALLOWED_OVERRIDES.add(ResourceLocation.withDefaultNamespace((String)"tooting"));
    }

    public record BakedModelKey(BakedModel model, ItemDisplayContext displayContext, Material material, boolean foil) {
    }

    public record BakedMeshKey(BakedModel model, ItemDisplayContext displayContext) {
    }
}

