/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.elements;

import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.Visual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.LineModelBuilder;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class HitboxElement
implements Visual,
SimpleDynamicVisual {
    public static final Model BOX_MODEL = new LineModelBuilder(12).line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f).build();
    public static final Model LINE_MODEL = new LineModelBuilder(1).line(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f).build();
    private final VisualizationContext context;
    private final Entity entity;
    private final SmartRecycler<Model, TransformedInstance> recycler;
    private boolean showEyeBox;

    public HitboxElement(VisualizationContext context, Entity entity, float partialTick) {
        this.context = context;
        this.entity = entity;
        this.showEyeBox = entity instanceof LivingEntity;
        this.recycler = new SmartRecycler(this::createInstance);
        this.animate(partialTick);
    }

    public HitboxElement(VisualizationContext context, Entity entity, float partialTick, boolean showEyeBox) {
        this(context, entity, partialTick);
        this.showEyeBox = showEyeBox;
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = (TransformedInstance)this.context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(240);
        instance.setChanged();
        return instance;
    }

    public boolean doesShowEyeBox() {
        return this.showEyeBox;
    }

    public HitboxElement showEyeBox(boolean showEyeBox) {
        this.showEyeBox = showEyeBox;
        return this;
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.animate(context.partialTick());
    }

    public void update(float partialTick) {
    }

    public void delete() {
        this.recycler.delete();
    }

    public void animate(float partialTick) {
        this.recycler.resetCount();
        boolean shouldRenderHitBoxes = Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes();
        if (shouldRenderHitBoxes && !this.entity.isInvisible() && !Minecraft.getInstance().showOnlyReducedInfo()) {
            double entityX = Mth.lerp((double)partialTick, (double)this.entity.xOld, (double)this.entity.getX());
            double entityY = Mth.lerp((double)partialTick, (double)this.entity.yOld, (double)this.entity.getY());
            double entityZ = Mth.lerp((double)partialTick, (double)this.entity.zOld, (double)this.entity.getZ());
            AABB bb = this.entity.getBoundingBox();
            double boxX = entityX + bb.minX - this.entity.getX();
            double boxY = entityY + bb.minY - this.entity.getY();
            double boxZ = entityZ + bb.minZ - this.entity.getZ();
            float widthX = (float)(bb.maxX - bb.minX);
            float widthY = (float)(bb.maxY - bb.minY);
            float widthZ = (float)(bb.maxZ - bb.minZ);
            ((TransformedInstance)((TransformedInstance)this.recycler.get((Object)BOX_MODEL)).setIdentityTransform().translate(boxX, boxY, boxZ)).scale(widthX, widthY, widthZ).setChanged();
            if (this.showEyeBox) {
                ((TransformedInstance)((TransformedInstance)this.recycler.get((Object)BOX_MODEL)).setIdentityTransform().translate(boxX, entityY + (double)this.entity.getEyeHeight() - 0.01, boxZ)).scale(widthX, 0.02f, widthZ).color(255, 0, 0).setChanged();
            }
            Vec3 viewVector = this.entity.getViewVector(partialTick);
            ((TransformedInstance)((TransformedInstance)this.recycler.get((Object)LINE_MODEL)).setIdentityTransform().translate(entityX, entityY + (double)this.entity.getEyeHeight(), entityZ)).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)viewVector.x, (float)viewVector.y, (float)viewVector.z)).color(0, 0, 255).setChanged();
        }
        this.recycler.discardExtra();
    }
}

