/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.vertex.MutableVertexList;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.QuadMesh;
import dev.engine_room.flywheel.lib.model.SingleMeshModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class FireElement
extends AbstractVisual
implements SimpleDynamicVisual {
    private static final Material FIRE_MATERIAL = SimpleMaterial.builderOf((Material)Materials.CUTOUT_UNSHADED_BLOCK).backfaceCulling(false).build();
    private static final RendererReloadCache<net.minecraft.client.resources.model.Material, Model> FIRE_MODELS = new RendererReloadCache(texture -> new SingleMeshModel((Mesh)new FireMesh(texture.sprite()), FIRE_MATERIAL));
    private final Entity entity;
    private final PoseStack stack = new PoseStack();
    private final SmartRecycler<Model, TransformedInstance> recycler;

    public FireElement(VisualizationContext ctx, Entity entity, float partialTick) {
        super(ctx, entity.level(), partialTick);
        this.entity = entity;
        this.recycler = new SmartRecycler(this::createInstance);
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = (TransformedInstance)this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(240);
        instance.setChanged();
        return instance;
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.recycler.resetCount();
        if (this.entity.displayFireAnimation()) {
            this.setupInstances(context);
        }
        this.recycler.discardExtra();
    }

    private void setupInstances(DynamicVisual.Context context) {
        double entityX = Mth.lerp((double)context.partialTick(), (double)this.entity.xOld, (double)this.entity.getX());
        double entityY = Mth.lerp((double)context.partialTick(), (double)this.entity.yOld, (double)this.entity.getY());
        double entityZ = Mth.lerp((double)context.partialTick(), (double)this.entity.zOld, (double)this.entity.getZ());
        Vec3i renderOrigin = this.visualizationContext.renderOrigin();
        float scale = this.entity.getBbWidth() * 1.4f;
        float maxHeight = this.entity.getBbHeight() / scale;
        float width = 1.0f;
        float y = 0.0f;
        float z = 0.0f;
        this.stack.setIdentity();
        this.stack.translate(entityX - (double)renderOrigin.getX(), entityY - (double)renderOrigin.getY(), entityZ - (double)renderOrigin.getZ());
        this.stack.scale(scale, scale, scale);
        this.stack.mulPose(Axis.YP.rotationDegrees(-context.camera().getYRot()));
        this.stack.translate(0.0f, 0.0f, -0.3f + (float)((int)maxHeight) * 0.02f);
        int i = 0;
        while (y < maxHeight) {
            TransformedInstance instance = ((TransformedInstance)((TransformedInstance)this.recycler.get((Object)((Model)FIRE_MODELS.get((Object)(i % 2 == 0 ? ModelBakery.FIRE_0 : ModelBakery.FIRE_1))))).setTransform(this.stack).scaleX(width)).translate(0.0f, y, z);
            if (i / 2 % 2 == 0) {
                instance.scaleX(-1.0f);
            }
            instance.setChanged();
            y += 0.45f;
            width *= 0.9f;
            z += 0.03f;
            ++i;
        }
    }

    public void _delete() {
        this.recycler.delete();
    }

    private record FireMesh(TextureAtlasSprite sprite) implements QuadMesh
    {
        private static final Vector4fc BOUNDING_SPHERE = new Vector4f(0.0f, 0.5f, 0.0f, Mth.SQRT_OF_TWO * 0.5f);

        public int vertexCount() {
            return 4;
        }

        public void write(MutableVertexList vertexList) {
            float u0 = this.sprite.getU0();
            float v0 = this.sprite.getV0();
            float u1 = this.sprite.getU1();
            float v1 = this.sprite.getV1();
            FireMesh.writeVertex(vertexList, 0, 0.5f, 0.0f, u1, v1);
            FireMesh.writeVertex(vertexList, 1, -0.5f, 0.0f, u0, v1);
            FireMesh.writeVertex(vertexList, 2, -0.5f, 1.4f, u0, v0);
            FireMesh.writeVertex(vertexList, 3, 0.5f, 1.4f, u1, v0);
        }

        private static void writeVertex(MutableVertexList vertexList, int i, float x, float y, float u, float v) {
            vertexList.x(i, x);
            vertexList.y(i, y);
            vertexList.z(i, 0.0f);
            vertexList.r(i, 1.0f);
            vertexList.g(i, 1.0f);
            vertexList.b(i, 1.0f);
            vertexList.u(i, u);
            vertexList.v(i, v);
            vertexList.light(i, 240);
            vertexList.normalX(i, 0.0f);
            vertexList.normalY(i, 1.0f);
            vertexList.normalZ(i, 0.0f);
        }

        public Vector4fc boundingSphere() {
            return BOUNDING_SPHERE;
        }
    }
}

