/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.config;

import dev.engine_room.flywheel.lib.visualization.SimpleEntityVisualizer;
import dev.engine_room.vanillin.config.Configurator;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public final class EntityVisualizerBuilder<T extends Entity> {
    private final Configurator configurator;
    private final EntityType<T> type;
    @Nullable
    private SimpleEntityVisualizer.Factory<T> visualFactory;
    @Nullable
    private Predicate<T> skipVanillaRender;

    public EntityVisualizerBuilder(Configurator configurator, EntityType<T> type) {
        this.configurator = configurator;
        this.type = type;
    }

    public EntityVisualizerBuilder<T> factory(SimpleEntityVisualizer.Factory<T> visualFactory) {
        this.visualFactory = visualFactory;
        return this;
    }

    public EntityVisualizerBuilder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
        this.skipVanillaRender = skipVanillaRender;
        return this;
    }

    public EntityVisualizerBuilder<T> neverSkipVanillaRender() {
        this.skipVanillaRender = entity -> false;
        return this;
    }

    public SimpleEntityVisualizer<T> apply(boolean enabledByDefault) {
        Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
        if (this.skipVanillaRender == null) {
            this.skipVanillaRender = entity -> true;
        }
        SimpleEntityVisualizer visualizer = new SimpleEntityVisualizer(this.visualFactory, this.skipVanillaRender);
        this.configurator.register(this.type, visualizer, enabledByDefault);
        return visualizer;
    }
}

