/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin;

import com.electronwill.nightconfig.core.Config;
import dev.engine_room.vanillin.VanillaVisuals;
import dev.engine_room.vanillin.Vanillin;
import dev.engine_room.vanillin.config.Configurator;
import dev.engine_room.vanillin.config.ModOverrides;
import dev.engine_room.vanillin.config.VisualConfigValue;
import dev.engine_room.vanillin.config.VisualOverride;
import dev.engine_room.vanillin.config.VisualOverrideValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class NeoForgeVanillinConfig {
    public static final NeoForgeVanillinConfig INSTANCE = new NeoForgeVanillinConfig(VanillaVisuals.CONFIGURATOR);
    private final Configurator configurator;
    private final ModConfigSpec clientSpec;
    private final ConfigSection blockEntities;
    private final ConfigSection entities;

    private NeoForgeVanillinConfig(Configurator configurator) {
        this.configurator = configurator;
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        Map<String, ModConfigSpec.EnumValue<VisualConfigValue>> blockEntities = NeoForgeVanillinConfig.setup(builder, configurator.blockEntities.values(), "block_entities");
        Map<String, ModConfigSpec.EnumValue<VisualConfigValue>> entities = NeoForgeVanillinConfig.setup(builder, configurator.entities.values(), "entities");
        this.clientSpec = builder.build();
        ModOverrides modOverrides = NeoForgeVanillinConfig.modOverrides();
        this.blockEntities = new ConfigSection(blockEntities, modOverrides.blockEntities());
        this.entities = new ConfigSection(entities, modOverrides.entities());
    }

    public void apply() {
        this.blockEntities.apply(this.configurator.blockEntities.values());
        this.entities.apply(this.configurator.entities.values());
    }

    public void registerSpecs(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
    }

    private static ModOverrides modOverrides() {
        ArrayList<VisualOverride> blockEntities = new ArrayList<VisualOverride>();
        ArrayList<VisualOverride> entities = new ArrayList<VisualOverride>();
        ModList.get().forEachModFile(file -> {
            IModFileInfo info = file.getModFileInfo();
            for (IModInfo mod : info.getMods()) {
                String modId = mod.getModId();
                Object modProperties = mod.getModProperties().get("vanillin:overrides");
                if (modProperties == null) continue;
                if (modProperties instanceof Config) {
                    Config config = (Config)modProperties;
                    NeoForgeVanillinConfig.readSection(blockEntities, modId, config, "block_entities", "block entity");
                    NeoForgeVanillinConfig.readSection(entities, modId, config, "entities", "entity");
                    continue;
                }
                Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override options with an invalid value, ignoring", (Object)modId);
            }
        });
        return new ModOverrides(blockEntities, entities);
    }

    private static void readSection(List<VisualOverride> dst, String modId, Config config, String section, String singular) {
        if (!config.contains(section)) {
            return;
        }
        Object sectionObject = config.getRaw(section);
        if (sectionObject instanceof Config) {
            Config sectionConfig = (Config)sectionObject;
            for (Config.Entry entry : sectionConfig.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    String valueString = (String)value;
                    VisualOverrideValue parsed = VisualOverrideValue.parse(valueString);
                    if (parsed != null) {
                        dst.add(new VisualOverride(key, modId, parsed));
                        continue;
                    }
                    Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override {} '{}' with an invalid value '{}', ignoring", new Object[]{modId, singular, key, valueString});
                    continue;
                }
                Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override {} '{}' with an invalid value, ignoring", new Object[]{modId, singular, key});
            }
        } else {
            Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override {} with an invalid value, ignoring", (Object)modId, (Object)section);
        }
    }

    private static Map<String, ModConfigSpec.EnumValue<VisualConfigValue>> setup(ModConfigSpec.Builder builder, Collection<? extends Configurator.ConfiguredVisual> configuredVisuals, String push) {
        HashMap<String, ModConfigSpec.EnumValue<VisualConfigValue>> out = new HashMap<String, ModConfigSpec.EnumValue<VisualConfigValue>>();
        builder.push(push);
        for (Configurator.ConfiguredVisual configuredVisual : configuredVisuals) {
            String name = configuredVisual.configKey();
            ModConfigSpec.EnumValue config = builder.defineEnum(name, (Enum)VisualConfigValue.DEFAULT);
            out.put(name, (ModConfigSpec.EnumValue<VisualConfigValue>)config);
        }
        builder.pop();
        return out;
    }

    private record ConfigSection(Map<String, ModConfigSpec.EnumValue<VisualConfigValue>> config, Map<String, List<VisualOverride>> overrides) {
        void apply(Collection<? extends Configurator.ConfiguredVisual> values) {
            for (Configurator.ConfiguredVisual configuredVisual : values) {
                String key = configuredVisual.configKey();
                ModConfigSpec.EnumValue<VisualConfigValue> value = this.config.get(key);
                if (value == null) continue;
                configuredVisual.set((VisualConfigValue)((Object)value.get()), this.overrides.get(key));
            }
        }
    }
}

