/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ParticleVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SingleQuadParticle.class})
public abstract class SingleQuadParticleMixin
extends Particle {
    @Unique
    private static final Vector3f TEMP_LEFT = new Vector3f();
    @Unique
    private static final Vector3f TEMP_UP = new Vector3f();

    @Shadow
    public abstract float getQuadSize(float var1);

    @Shadow
    protected abstract float getU0();

    @Shadow
    protected abstract float getU1();

    @Shadow
    protected abstract float getV0();

    @Shadow
    protected abstract float getV1();

    protected SingleQuadParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        float size = this.getQuadSize(tickDelta);
        Vector3f left = TEMP_LEFT;
        left.set((Vector3fc)camera.getLeftVector()).mul(size);
        Vector3f up = TEMP_UP;
        up.set((Vector3fc)camera.getUpVector()).mul(size);
        if (!Mth.equal((float)this.roll, (float)0.0f)) {
            float roll = Mth.lerp((float)tickDelta, (float)this.oRoll, (float)this.roll);
            float sinRoll = Math.sin((float)roll);
            float cosRoll = Math.cosFromSin((float)sinRoll, (float)roll);
            float rv1x = Math.fma((float)cosRoll, (float)left.x, (float)(sinRoll * up.x));
            float rv1y = Math.fma((float)cosRoll, (float)left.y, (float)(sinRoll * up.y));
            float rv1z = Math.fma((float)cosRoll, (float)left.z, (float)(sinRoll * up.z));
            float rv2x = Math.fma((float)(-sinRoll), (float)left.x, (float)(cosRoll * up.x));
            float rv2y = Math.fma((float)(-sinRoll), (float)left.y, (float)(cosRoll * up.y));
            float rv2z = Math.fma((float)(-sinRoll), (float)left.z, (float)(cosRoll * up.z));
            left.set(rv1x, rv1y, rv1z);
            up.set(rv2x, rv2y, rv2z);
        }
        this.sodium$emitVertices(writer, camera.getPosition(), left, up, tickDelta);
    }

    @Inject(method={"renderRotatedQuad(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;Lorg/joml/Quaternionf;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void renderRotatedQuad(VertexConsumer vertexConsumer, Camera camera, Quaternionf quaternion, float tickDelta, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        float size = this.getQuadSize(tickDelta);
        Vector3f left = TEMP_LEFT;
        left.set(-size, 0.0f, 0.0f).rotate((Quaternionfc)quaternion);
        Vector3f up = TEMP_UP;
        up.set(0.0f, size, 0.0f).rotate((Quaternionfc)quaternion);
        this.sodium$emitVertices(writer, camera.getPosition(), left, up, tickDelta);
    }

    @Unique
    private void sodium$emitVertices(VertexBufferWriter writer, Vec3 camera, Vector3f left, Vector3f up, float tickDelta) {
        float minU = this.getU0();
        float maxU = this.getU1();
        float minV = this.getV0();
        float maxV = this.getV1();
        int light = this.getLightColor(tickDelta);
        int color = ColorABGR.pack(this.rCol, this.gCol, this.bCol, this.alpha);
        float x = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - camera.x());
        float y = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - camera.y());
        float z = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - camera.z());
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            ParticleVertex.put(ptr, -left.x - up.x + x, -left.y - up.y + y, -left.z - up.z + z, maxU, maxV, color, light);
            ParticleVertex.put(ptr += 28L, -left.x + up.x + x, -left.y + up.y + y, -left.z + up.z + z, maxU, minV, color, light);
            ParticleVertex.put(ptr += 28L, left.x + up.x + x, left.y + up.y + y, left.z + up.z + z, minU, minV, color, light);
            ParticleVertex.put(ptr += 28L, left.x - up.x + x, left.y - up.y + y, left.z - up.z + z, minU, maxV, color, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }
}

