/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.helper;

import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public abstract class GeometryHelper {
    private GeometryHelper() {
    }

    public static boolean isQuadParallelToFace(Direction face, QuadView quad) {
        int i = face.getAxis().ordinal();
        float val = quad.posByIndex(0, i);
        return Mth.equal((float)val, (float)quad.posByIndex(1, i)) && Mth.equal((float)val, (float)quad.posByIndex(2, i)) && Mth.equal((float)val, (float)quad.posByIndex(3, i));
    }

    public static Direction lightFace(QuadView quad) {
        Vector3f normal = quad.faceNormal();
        return switch (GeometryHelper.longestAxis(normal)) {
            case Direction.Axis.X -> {
                if (normal.x() > 0.0f) {
                    yield Direction.EAST;
                }
                yield Direction.WEST;
            }
            case Direction.Axis.Y -> {
                if (normal.y() > 0.0f) {
                    yield Direction.UP;
                }
                yield Direction.DOWN;
            }
            case Direction.Axis.Z -> {
                if (normal.z() > 0.0f) {
                    yield Direction.SOUTH;
                }
                yield Direction.NORTH;
            }
            default -> Direction.UP;
        };
    }

    public static Direction.Axis longestAxis(Vector3f vec) {
        return GeometryHelper.longestAxis(vec.x(), vec.y(), vec.z());
    }

    public static Direction.Axis longestAxis(float normalX, float normalY, float normalZ) {
        Direction.Axis result = Direction.Axis.Y;
        float longest = Math.abs(normalY);
        float a = Math.abs(normalX);
        if (a > longest) {
            result = Direction.Axis.X;
            longest = a;
        }
        return Math.abs(normalZ) > longest ? Direction.Axis.Z : result;
    }
}

