/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

import net.caffeinemc.mods.sodium.client.render.chunk.lists.CoordinateSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.Tree;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.core.SectionPos;

public class TraversableTree
extends Tree {
    private static final int INSIDE_FRUSTUM = 1;
    private static final int INSIDE_DISTANCE = 2;
    private static final int FULLY_INSIDE = 3;
    protected final long[] treeReduced = new long[64];
    public long treeDoubleReduced = 0L;
    private int cameraOffsetX;
    private int cameraOffsetY;
    private int cameraOffsetZ;
    private CoordinateSectionVisitor visitor;
    protected Viewport viewport;
    private float distanceLimit;

    public TraversableTree(int offsetX, int offsetY, int offsetZ) {
        super(offsetX, offsetY, offsetZ);
    }

    public void prepareForTraversal() {
        long doubleReduced = 0L;
        for (int i = 0; i < 64; ++i) {
            long reduced = 0L;
            int reducedOffset = i << 6;
            for (int j = 0; j < 64; ++j) {
                reduced |= this.tree[reducedOffset + j] == 0L ? 0L : 1L << j;
            }
            this.treeReduced[i] = reduced;
            doubleReduced |= reduced == 0L ? 0L : 1L << i;
        }
        this.treeDoubleReduced = doubleReduced;
    }

    @Override
    public int getPresence(int x, int y, int z) {
        if (TraversableTree.isOutOfBounds(x -= this.offsetX, y -= this.offsetY, z -= this.offsetZ)) {
            return -1;
        }
        int bitIndex = TraversableTree.interleave6x3(x, y, z);
        int doubleReducedBitIndex = bitIndex >> 12;
        if ((this.treeDoubleReduced & 1L << doubleReducedBitIndex) == 0L) {
            return 0;
        }
        int reducedBitIndex = bitIndex >> 6;
        return (this.tree[reducedBitIndex] & 1L << (bitIndex & 0x3F)) != 0L ? 1 : 0;
    }

    public void traverse(CoordinateSectionVisitor visitor, Viewport viewport, float distanceLimit, float buildDistance) {
        this.visitor = visitor;
        this.viewport = viewport;
        this.distanceLimit = distanceLimit;
        SectionPos sectionPos = viewport.getChunkCoord();
        this.cameraOffsetX = sectionPos.getX() - this.offsetX + 1;
        this.cameraOffsetY = sectionPos.getY() - this.offsetY + 1;
        this.cameraOffsetZ = sectionPos.getZ() - this.offsetZ + 1;
        int initialInside = this.distanceLimit >= buildDistance ? 2 : 0;
        this.traverse(this.getChildOrderModulator(0, 0, 0, 32), 0, 5, initialInside);
        this.visitor = null;
        this.viewport = null;
    }

    void traverse(int orderModulator, int nodeOrigin, int level, int inside) {
        int childHalfDim = 1 << level + 3;
        if ((level & 1) == 1) {
            orderModulator <<= 3;
        }
        if (level <= 1) {
            int childOriginBase = nodeOrigin & 0x3FFC0;
            long map = this.tree[nodeOrigin >> 6];
            if (level == 0) {
                int startBit = nodeOrigin & 0x3F;
                int endBit = startBit + 8;
                for (int bitIndex = startBit; bitIndex < endBit; ++bitIndex) {
                    int childIndex = bitIndex ^ orderModulator;
                    if ((map & 1L << childIndex) == 0L) continue;
                    int sectionOrigin = childOriginBase | childIndex;
                    int x = TraversableTree.deinterleave6(sectionOrigin) + this.offsetX;
                    int y = TraversableTree.deinterleave6(sectionOrigin >> 1) + this.offsetY;
                    int z = TraversableTree.deinterleave6(sectionOrigin >> 2) + this.offsetZ;
                    if (inside != 3 && !this.testLeafNode(x, y, z, inside)) continue;
                    this.visitor.visit(x, y, z);
                }
            } else {
                for (int bitIndex = 0; bitIndex < 64; bitIndex += 8) {
                    int childIndex = bitIndex ^ orderModulator;
                    if ((map & 255L << childIndex) == 0L) continue;
                    this.testChild(childOriginBase | childIndex, childHalfDim, level, inside);
                }
            }
        } else if (level <= 3) {
            int childOriginBase = nodeOrigin & 0x3F000;
            long map = this.treeReduced[nodeOrigin >> 12];
            if (level == 2) {
                int startBit = nodeOrigin >> 6 & 0x3F;
                int endBit = startBit + 8;
                for (int bitIndex = startBit; bitIndex < endBit; ++bitIndex) {
                    int childIndex = bitIndex ^ orderModulator;
                    if ((map & 1L << childIndex) == 0L) continue;
                    this.testChild(childOriginBase | childIndex << 6, childHalfDim, level, inside);
                }
            } else {
                for (int bitIndex = 0; bitIndex < 64; bitIndex += 8) {
                    int childIndex = bitIndex ^ orderModulator;
                    if ((map & 255L << childIndex) == 0L) continue;
                    this.testChild(childOriginBase | childIndex << 6, childHalfDim, level, inside);
                }
            }
        } else if (level == 4) {
            int startBit = nodeOrigin >> 12;
            int endBit = startBit + 8;
            for (int bitIndex = startBit; bitIndex < endBit; ++bitIndex) {
                int childIndex = bitIndex ^ orderModulator;
                if ((this.treeDoubleReduced & 1L << childIndex) == 0L) continue;
                this.testChild(childIndex << 12, childHalfDim, level, inside);
            }
        } else {
            for (int bitIndex = 0; bitIndex < 64; bitIndex += 8) {
                int childIndex = bitIndex ^ orderModulator;
                if ((this.treeDoubleReduced & 255L << childIndex) == 0L) continue;
                this.testChild(childIndex << 12, childHalfDim, level, inside);
            }
        }
    }

    void testChild(int childOrigin, int childHalfDim, int level, int inside) {
        float dz;
        float dy;
        int childFullDim;
        float dx;
        int x = TraversableTree.deinterleave6(childOrigin);
        int y = TraversableTree.deinterleave6(childOrigin >> 1);
        int z = TraversableTree.deinterleave6(childOrigin >> 2);
        if (inside == 3) {
            this.traverse(this.getChildOrderModulator(x, y, z, 1 << --level), childOrigin, level, inside);
            return;
        }
        CameraTransform transform = this.viewport.getTransform();
        int worldX = (x + this.offsetX << 4) - transform.intX;
        int worldY = (y + this.offsetY << 4) - transform.intY;
        int worldZ = (z + this.offsetZ << 4) - transform.intZ;
        boolean visible = true;
        if ((inside & 1) == 0) {
            int intersectionResult = this.viewport.getBoxIntersectionDirect((float)(worldX + childHalfDim) - transform.fracX, (float)(worldY + childHalfDim) - transform.fracY, (float)(worldZ + childHalfDim) - transform.fracZ, (float)childHalfDim + 1.125f);
            if (intersectionResult == -2) {
                inside |= 1;
            } else {
                boolean bl = visible = intersectionResult == -1;
            }
        }
        if ((inside & 2) == 0 && (visible = TraversableTree.cylindricalDistanceTest(dx = (float)TraversableTree.nearestToZero(worldX, worldX + (childFullDim = childHalfDim << 1)) - transform.fracX, dy = (float)TraversableTree.nearestToZero(worldY, worldY + childFullDim) - transform.fracY, dz = (float)TraversableTree.nearestToZero(worldZ, worldZ + childFullDim) - transform.fracZ, this.distanceLimit)) && TraversableTree.cylindricalDistanceTest(dx = (float)TraversableTree.farthestFromZero(worldX, worldX + childFullDim) - transform.fracX, dy = (float)TraversableTree.farthestFromZero(worldY, worldY + childFullDim) - transform.fracY, dz = (float)TraversableTree.farthestFromZero(worldZ, worldZ + childFullDim) - transform.fracZ, this.distanceLimit)) {
            inside |= 2;
        }
        if (visible) {
            this.traverse(this.getChildOrderModulator(x, y, z, 1 << --level), childOrigin, level, inside);
        }
    }

    boolean testLeafNode(int x, int y, int z, int inside) {
        CameraTransform transform = this.viewport.getTransform();
        x = (x << 4) - transform.intX;
        y = (y << 4) - transform.intY;
        z = (z << 4) - transform.intZ;
        if ((inside & 1) == 0 && !this.viewport.isBoxVisibleDirect((float)(x + 8) - transform.fracX, (float)(y + 8) - transform.fracY, (float)(z + 8) - transform.fracZ, 8.0f)) {
            return false;
        }
        if ((inside & 2) == 0) {
            float dx = (float)TraversableTree.nearestToZero(x - 1, x + 17) - transform.fracX;
            float dy = (float)TraversableTree.nearestToZero(y - 1, y + 17) - transform.fracY;
            float dz = (float)TraversableTree.nearestToZero(z - 1, z + 17) - transform.fracZ;
            return TraversableTree.cylindricalDistanceTest(dx, dy, dz, this.distanceLimit);
        }
        return true;
    }

    static boolean cylindricalDistanceTest(float dx, float dy, float dz, float distanceLimit) {
        return dx * dx + dz * dz < distanceLimit * distanceLimit && Math.abs(dy) < distanceLimit;
    }

    private static int nearestToZero(int min, int max) {
        int clamped = 0;
        if (min > 0) {
            clamped = min;
        }
        if (max < 0) {
            clamped = max;
        }
        return clamped;
    }

    private static int farthestFromZero(int min, int max) {
        int clamped = 0;
        if (min > 0) {
            clamped = max;
        }
        if (max < 0) {
            clamped = min;
        }
        if (clamped == 0) {
            clamped = Math.abs(min) > Math.abs(max) ? min : max;
        }
        return clamped;
    }

    int getChildOrderModulator(int x, int y, int z, int childFullSectionDim) {
        return x + childFullSectionDim - this.cameraOffsetX >>> 31 | y + childFullSectionDim - this.cameraOffsetY >>> 31 << 1 | z + childFullSectionDim - this.cameraOffsetZ >>> 31 << 2;
    }
}

