/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

import it.unimi.dsi.fastutil.ints.IntArrays;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.CoordinateSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.BaseMultiForest;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.TraversableForest;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.TraversableTree;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.core.SectionPos;

public abstract class AbstractTraversableMultiForest<T extends TraversableTree>
extends BaseMultiForest<T>
implements TraversableForest {
    public AbstractTraversableMultiForest(int baseOffsetX, int baseOffsetY, int baseOffsetZ, float buildDistance) {
        super(baseOffsetX, baseOffsetY, baseOffsetZ, buildDistance);
    }

    @Override
    public void prepareForTraversal() {
        for (TraversableTree tree : (TraversableTree[])this.trees) {
            if (tree == null) continue;
            tree.prepareForTraversal();
        }
    }

    @Override
    public void traverse(CoordinateSectionVisitor visitor, Viewport viewport, float distanceLimit) {
        SectionPos cameraPos = viewport.getChunkCoord();
        int cameraSectionX = cameraPos.getX();
        int cameraSectionY = cameraPos.getY();
        int cameraSectionZ = cameraPos.getZ();
        int[] items = new int[((TraversableTree[])this.trees).length];
        for (int i = 0; i < ((TraversableTree[])this.trees).length; ++i) {
            TraversableTree tree = ((TraversableTree[])this.trees)[i];
            if (tree == null) continue;
            int deltaX = Math.abs(tree.offsetX + 32 - cameraSectionX);
            int deltaY = Math.abs(tree.offsetY + 32 - cameraSectionY);
            int deltaZ = Math.abs(tree.offsetZ + 32 - cameraSectionZ);
            items[i] = deltaX + deltaY + deltaZ + 1 << 16 | i;
        }
        IntArrays.unstableSort((int[])items);
        for (int item : items) {
            TraversableTree tree;
            if (item == 0 || (tree = ((TraversableTree[])this.trees)[item & 0xFFFF]) == null) continue;
            tree.traverse(visitor, viewport, distanceLimit, this.buildDistance);
        }
    }
}

