/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.Collection;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.Group;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.SortTriggering;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.interval_tree.DoubleInterval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.Interval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.IntervalTree;
import org.joml.Vector3fc;

public class NormalList {
    private static final int HASH_SET_THRESHOLD = 20;
    private static final int ARRAY_SET_THRESHOLD = 10;
    private final Vector3fc normal;
    private final int alignedDirection;
    private final IntervalTree<Double> intervalTree = new IntervalTree();
    private final Object2ReferenceOpenHashMap<DoubleInterval, Collection<Group>> groupsByInterval = new Object2ReferenceOpenHashMap();
    private final Long2ReferenceOpenHashMap<Group> groupsBySection = new Long2ReferenceOpenHashMap();

    NormalList(Vector3fc normal, int alignedDirection) {
        this.normal = normal;
        this.alignedDirection = alignedDirection;
    }

    public Vector3fc getNormal() {
        return this.normal;
    }

    public boolean isAligned() {
        return this.alignedDirection != ModelQuadFacing.UNASSIGNED_ORDINAL;
    }

    public int getAlignedDirection() {
        return this.alignedDirection;
    }

    void processMovement(SortTriggering ts, CameraMovement movement) {
        double end;
        double start = MathUtil.floatDoubleDot(this.normal, movement.start());
        if (start >= (end = MathUtil.floatDoubleDot(this.normal, movement.end()))) {
            return;
        }
        DoubleInterval interval = new DoubleInterval(start, end, Interval.Bounded.CLOSED);
        for (Interval<Double> groupInterval : this.intervalTree.query(interval)) {
            for (Group group : (Collection)this.groupsByInterval.get(groupInterval)) {
                group.triggerRange(ts, start, end);
            }
        }
    }

    void processCatchup(SortTriggering ts, CameraMovement movement, long sectionPos) {
        double end;
        double start = MathUtil.floatDoubleDot(this.normal, movement.start());
        if (start >= (end = MathUtil.floatDoubleDot(this.normal, movement.end()))) {
            return;
        }
        Group group = (Group)this.groupsBySection.get(sectionPos);
        if (group != null) {
            group.triggerRange(ts, start, end);
        }
    }

    private void removeGroupInterval(Group group) {
        Collection groups = (Collection)this.groupsByInterval.get((Object)group.distances);
        if (groups != null) {
            groups.remove(group);
            if (groups.isEmpty()) {
                this.groupsByInterval.remove((Object)group.distances);
                this.intervalTree.remove(group.distances);
            } else if (groups.size() <= 10) {
                groups = new ReferenceArraySet(groups);
                this.groupsByInterval.put((Object)group.distances, (Object)groups);
            }
        }
    }

    private void addGroupInterval(Group group) {
        Collection groups = (Collection)this.groupsByInterval.get((Object)group.distances);
        if (groups == null) {
            groups = new ReferenceArraySet();
            this.groupsByInterval.put((Object)group.distances, (Object)groups);
            this.intervalTree.add(group.distances);
        } else if (groups.size() >= 20) {
            groups = new ReferenceLinkedOpenHashSet(groups);
            this.groupsByInterval.put((Object)group.distances, (Object)groups);
        }
        groups.add(group);
    }

    boolean hasSection(long sectionPos) {
        return this.groupsBySection.containsKey(sectionPos);
    }

    boolean isEmpty() {
        return this.groupsBySection.isEmpty();
    }

    void addSection(NormalPlanes normalPlanes, long sectionPos) {
        Group group = new Group(normalPlanes);
        this.groupsBySection.put(sectionPos, (Object)group);
        this.addGroupInterval(group);
    }

    void removeSection(long sectionPos) {
        Group group = (Group)this.groupsBySection.remove(sectionPos);
        if (group != null) {
            this.removeGroupInterval(group);
        }
    }

    void updateSection(NormalPlanes normalPlanes, long sectionPos) {
        Group group = (Group)this.groupsBySection.get(sectionPos);
        if (group.normalPlanesEquals(normalPlanes)) {
            return;
        }
        this.removeGroupInterval(group);
        group.replaceWith(normalPlanes);
        this.addGroupInterval(group);
    }

    public static boolean queryRange(float[] sortedDistances, float start, float end) {
        int result = FloatArrays.binarySearch((float[])sortedDistances, (float)start);
        if (result < 0) {
            int insertionPoint = -result - 1;
            if (insertionPoint >= sortedDistances.length) {
                return false;
            }
            return sortedDistances[insertionPoint] <= end;
        }
        return true;
    }
}

