/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalPlanes;
import net.minecraft.core.SectionPos;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GeometryPlanes {
    private NormalPlanes[] alignedPlanes;
    private Object2ReferenceMap<Vector3fc, NormalPlanes> unalignedPlanes;
    private final Vector3f unalignedNormalScratch = new Vector3f();

    public NormalPlanes[] getAligned() {
        return this.alignedPlanes;
    }

    public NormalPlanes[] getAlignedOrCreate() {
        if (this.alignedPlanes == null) {
            this.alignedPlanes = new NormalPlanes[ModelQuadFacing.DIRECTIONS];
        }
        return this.alignedPlanes;
    }

    public Collection<NormalPlanes> getUnaligned() {
        if (this.unalignedPlanes == null) {
            return null;
        }
        return this.unalignedPlanes.values();
    }

    public Object2ReferenceMap<Vector3fc, NormalPlanes> getUnalignedOrCreate() {
        if (this.unalignedPlanes == null) {
            this.unalignedPlanes = new Object2ReferenceOpenHashMap();
        }
        return this.unalignedPlanes;
    }

    NormalPlanes getPlanesForNormal(NormalList normalList) {
        Vector3fc normal = normalList.getNormal();
        if (normalList.isAligned()) {
            if (this.alignedPlanes == null) {
                return null;
            }
            return this.alignedPlanes[normalList.getAlignedDirection()];
        }
        if (this.unalignedPlanes == null) {
            return null;
        }
        return (NormalPlanes)this.unalignedPlanes.get((Object)normal);
    }

    public void addAlignedPlane(SectionPos sectionPos, int direction, float distance) {
        NormalPlanes[] alignedDistances = this.getAlignedOrCreate();
        NormalPlanes normalPlanes = alignedDistances[direction];
        if (normalPlanes == null) {
            alignedDistances[direction] = normalPlanes = new NormalPlanes(sectionPos, direction);
        }
        normalPlanes.addPlaneMember(distance);
    }

    public void addDoubleSidedPlane(SectionPos sectionPos, int axis, float distance) {
        this.addAlignedPlane(sectionPos, axis, distance);
        this.addAlignedPlane(sectionPos, axis + 3, -distance);
    }

    public void addUnalignedPlane(SectionPos sectionPos, Vector3fc normal, float distance) {
        Vector3f cleanedNormal;
        Object2ReferenceMap<Vector3fc, NormalPlanes> unalignedDistances = this.getUnalignedOrCreate();
        NormalPlanes normalPlanes = (NormalPlanes)unalignedDistances.get((Object)(cleanedNormal = this.cleanNormal(normal)));
        if (normalPlanes == null) {
            normalPlanes = new NormalPlanes(sectionPos, (Vector3fc)new Vector3f(normal));
            unalignedDistances.put((Object)normalPlanes.normal, (Object)normalPlanes);
        }
        normalPlanes.addPlaneMember(distance);
    }

    private Vector3f cleanNormal(Vector3fc normal) {
        Vector3f cleanedNormal = this.unalignedNormalScratch.set(normal);
        if (cleanedNormal.x == 0.0f) {
            cleanedNormal.x = 0.0f;
        }
        if (cleanedNormal.y == 0.0f) {
            cleanedNormal.y = 0.0f;
        }
        if (cleanedNormal.z == 0.0f) {
            cleanedNormal.z = 0.0f;
        }
        return cleanedNormal;
    }

    public void addQuadPlane(SectionPos sectionPos, TQuad quad) {
        ModelQuadFacing facing = quad.useQuantizedFacing();
        if (facing.isAligned()) {
            this.addAlignedPlane(sectionPos, facing.ordinal(), quad.getQuantizedDotProduct());
        } else {
            this.addUnalignedPlane(sectionPos, quad.getQuantizedNormal(), quad.getQuantizedDotProduct());
        }
    }

    private void prepareAndInsert(Object2ReferenceMap<Vector3fc, float[]> distancesByNormal) {
        if (this.alignedPlanes != null) {
            for (ObjectIterator normalPlanes : this.alignedPlanes) {
                if (normalPlanes == null) continue;
                normalPlanes.prepareAndInsert(distancesByNormal);
            }
        }
        if (this.unalignedPlanes != null) {
            for (NormalPlanes normalPlanes : this.unalignedPlanes.values()) {
                normalPlanes.prepareAndInsert(distancesByNormal);
            }
        }
    }

    public void prepareIntegration() {
        this.prepareAndInsert(null);
    }

    public Object2ReferenceMap<Vector3fc, float[]> prepareAndGetDistances() {
        Object2ReferenceOpenHashMap distancesByNormal = new Object2ReferenceOpenHashMap(10);
        this.prepareAndInsert((Object2ReferenceMap<Vector3fc, float[]>)distancesByNormal);
        return distancesByNormal;
    }

    public static GeometryPlanes fromQuadLists(SectionPos sectionPos, TQuad[] quads) {
        GeometryPlanes geometryPlanes = new GeometryPlanes();
        for (TQuad quad : quads) {
            geometryPlanes.addQuadPlane(sectionPos, quad);
        }
        return geometryPlanes;
    }
}

