/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.occlusion;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.RenderSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirectionSet;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.VisibilityEncoding;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.util.collections.DoubleBufferedQueue;
import net.caffeinemc.mods.sodium.client.util.collections.ReadQueue;
import net.caffeinemc.mods.sodium.client.util.collections.WriteQueue;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OcclusionCuller {
    private final Long2ReferenceMap<RenderSection> sections;
    private final Level level;
    private final DoubleBufferedQueue<RenderSection> queue = new DoubleBufferedQueue();
    private static final long UP_DOWN_OCCLUDED = 1L << VisibilityEncoding.bit(0, 1) | 1L << VisibilityEncoding.bit(1, 0);
    private static final long NORTH_SOUTH_OCCLUDED = 1L << VisibilityEncoding.bit(2, 3) | 1L << VisibilityEncoding.bit(3, 2);
    private static final long WEST_EAST_OCCLUDED = 1L << VisibilityEncoding.bit(4, 5) | 1L << VisibilityEncoding.bit(5, 4);
    public static final float CHUNK_SECTION_RADIUS = 8.0f;
    public static final float CHUNK_SECTION_MARGIN = 1.125f;
    public static final float CHUNK_SECTION_SIZE = 9.125f;
    private static final float CHUNK_SECTION_SIZE_NEARBY = 10.125f;

    public OcclusionCuller(Long2ReferenceMap<RenderSection> sections, Level level) {
        this.sections = sections;
        this.level = level;
    }

    public void findVisible(RenderSectionVisitor visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame) {
        DoubleBufferedQueue<RenderSection> queues = this.queue;
        queues.reset();
        this.init(visitor, queues.write(), viewport, searchDistance, useOcclusionCulling, frame);
        while (queues.flip()) {
            OcclusionCuller.processQueue(visitor, viewport, searchDistance, useOcclusionCulling, frame, queues.read(), queues.write());
        }
        this.addNearbySections(visitor, viewport, searchDistance, frame);
    }

    private static void processQueue(RenderSectionVisitor visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame, ReadQueue<RenderSection> readQueue, WriteQueue<RenderSection> writeQueue) {
        RenderSection section;
        while ((section = readQueue.dequeue()) != null) {
            if (!OcclusionCuller.isSectionVisible(section, viewport, searchDistance)) continue;
            visitor.visit(section);
            if (useOcclusionCulling) {
                long sectionVisibilityData = section.getVisibilityData();
                connections = VisibilityEncoding.getConnections(sectionVisibilityData &= OcclusionCuller.getAngleVisibilityMask(viewport, section), section.getIncomingDirections());
            } else {
                connections = 63;
            }
            OcclusionCuller.visitNeighbors(writeQueue, section, connections &= OcclusionCuller.getOutwardDirections(viewport.getChunkCoord(), section), frame);
        }
    }

    private static long getAngleVisibilityMask(Viewport viewport, RenderSection section) {
        CameraTransform transform = viewport.getTransform();
        double dx = Math.abs(transform.x - (double)section.getCenterX());
        double dy = Math.abs(transform.y - (double)section.getCenterY());
        double dz = Math.abs(transform.z - (double)section.getCenterZ());
        long angleOcclusionMask = 0L;
        if (dx > dy || dz > dy) {
            angleOcclusionMask |= UP_DOWN_OCCLUDED;
        }
        if (dx > dz || dy > dz) {
            angleOcclusionMask |= NORTH_SOUTH_OCCLUDED;
        }
        if (dy > dx || dz > dx) {
            angleOcclusionMask |= WEST_EAST_OCCLUDED;
        }
        return angleOcclusionMask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static boolean isSectionVisible(RenderSection section, Viewport viewport, float maxDistance) {
        return OcclusionCuller.isWithinRenderDistance(viewport.getTransform(), section, maxDistance) && OcclusionCuller.isWithinFrustum(viewport, section);
    }

    private static void visitNeighbors(WriteQueue<RenderSection> queue, RenderSection section, int outgoing, int frame) {
        if ((outgoing &= section.getAdjacentMask()) == 0) {
            return;
        }
        queue.ensureCapacity(6);
        if (GraphDirectionSet.contains(outgoing, 0)) {
            OcclusionCuller.visitNode(queue, section.adjacentDown, GraphDirectionSet.of(1), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 1)) {
            OcclusionCuller.visitNode(queue, section.adjacentUp, GraphDirectionSet.of(0), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 2)) {
            OcclusionCuller.visitNode(queue, section.adjacentNorth, GraphDirectionSet.of(3), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 3)) {
            OcclusionCuller.visitNode(queue, section.adjacentSouth, GraphDirectionSet.of(2), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 4)) {
            OcclusionCuller.visitNode(queue, section.adjacentWest, GraphDirectionSet.of(5), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 5)) {
            OcclusionCuller.visitNode(queue, section.adjacentEast, GraphDirectionSet.of(4), frame);
        }
    }

    private static void visitNode(WriteQueue<RenderSection> queue, @NotNull RenderSection render, int incoming, int frame) {
        if (render.getLastVisibleFrame() != frame) {
            render.setLastVisibleFrame(frame);
            render.setIncomingDirections(0);
            queue.enqueue(render);
        }
        render.addIncomingDirections(incoming);
    }

    private static int getOutwardDirections(SectionPos origin, RenderSection section) {
        int planes = 0;
        planes |= section.getChunkX() <= origin.getX() ? 16 : 0;
        planes |= section.getChunkX() >= origin.getX() ? 32 : 0;
        planes |= section.getChunkY() <= origin.getY() ? 1 : 0;
        planes |= section.getChunkY() >= origin.getY() ? 2 : 0;
        planes |= section.getChunkZ() <= origin.getZ() ? 4 : 0;
        return planes |= section.getChunkZ() >= origin.getZ() ? 8 : 0;
    }

    private static boolean isWithinRenderDistance(CameraTransform camera, RenderSection section, float maxDistance) {
        int ox = section.getOriginX() - camera.intX;
        int oy = section.getOriginY() - camera.intY;
        int oz = section.getOriginZ() - camera.intZ;
        float dx = (float)OcclusionCuller.nearestToZero(ox - 1, ox + 17) - camera.fracX;
        float dy = (float)OcclusionCuller.nearestToZero(oy - 1, oy + 17) - camera.fracY;
        float dz = (float)OcclusionCuller.nearestToZero(oz - 1, oz + 17) - camera.fracZ;
        return dx * dx + dz * dz < maxDistance * maxDistance && Math.abs(dy) < maxDistance;
    }

    private static int nearestToZero(int min, int max) {
        int clamped = 0;
        if (min > 0) {
            clamped = min;
        }
        if (max < 0) {
            clamped = max;
        }
        return clamped;
    }

    public static boolean isWithinFrustum(Viewport viewport, RenderSection section) {
        return viewport.isBoxVisible(section.getCenterX(), section.getCenterY(), section.getCenterZ(), 9.125f, 9.125f, 9.125f);
    }

    public static boolean isWithinNearbySectionFrustum(Viewport viewport, RenderSection section) {
        return viewport.isBoxVisible(section.getCenterX(), section.getCenterY(), section.getCenterZ(), 10.125f, 10.125f, 10.125f);
    }

    private void addNearbySections(RenderSectionVisitor visitor, Viewport viewport, float searchDistance, int frame) {
        SectionPos origin = viewport.getChunkCoord();
        int originX = origin.getX();
        int originY = origin.getY();
        int originZ = origin.getZ();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    RenderSection section;
                    if (dx == 0 && dy == 0 && dz == 0 || (section = this.getRenderSection(originX + dx, originY + dy, originZ + dz)) == null || section.getLastVisibleFrame() == frame || !OcclusionCuller.isWithinNearbySectionFrustum(viewport, section)) continue;
                    section.setLastVisibleFrame(frame);
                    visitor.visit(section);
                }
            }
        }
    }

    private void init(RenderSectionVisitor visitor, WriteQueue<RenderSection> queue, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame) {
        SectionPos origin = viewport.getChunkCoord();
        if (origin.getY() < this.level.getMinSection()) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, this.level.getMinSection(), 0);
        } else if (origin.getY() >= this.level.getMaxSection()) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, this.level.getMaxSection() - 1, 1);
        } else {
            this.initWithinWorld(visitor, queue, viewport, useOcclusionCulling, frame);
        }
    }

    private void initWithinWorld(RenderSectionVisitor visitor, WriteQueue<RenderSection> queue, Viewport viewport, boolean useOcclusionCulling, int frame) {
        SectionPos origin = viewport.getChunkCoord();
        RenderSection section = this.getRenderSection(origin.getX(), origin.getY(), origin.getZ());
        if (section == null) {
            return;
        }
        section.setLastVisibleFrame(frame);
        section.setIncomingDirections(0);
        visitor.visit(section);
        int outgoing = useOcclusionCulling ? VisibilityEncoding.getConnections(section.getVisibilityData()) : 63;
        OcclusionCuller.visitNeighbors(queue, section, outgoing, frame);
    }

    private void initOutsideWorldHeight(WriteQueue<RenderSection> queue, Viewport viewport, float searchDistance, int frame, int height, int direction) {
        int layer;
        SectionPos origin = viewport.getChunkCoord();
        int radius = Mth.floor((float)(searchDistance / 16.0f));
        this.tryVisitNode(queue, origin.getX(), height, origin.getZ(), direction, frame, viewport);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                this.tryVisitNode(queue, origin.getX() + x, height, origin.getZ() + z, direction, frame, viewport);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                this.tryVisitNode(queue, origin.getX() + x, height, origin.getZ() + z, direction, frame, viewport);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                this.tryVisitNode(queue, origin.getX() + x, height, origin.getZ() + z, direction, frame, viewport);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                this.tryVisitNode(queue, origin.getX() + x, height, origin.getZ() + z, direction, frame, viewport);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                this.tryVisitNode(queue, origin.getX() + x, height, origin.getZ() + z, direction, frame, viewport);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                this.tryVisitNode(queue, origin.getX() + x, height, origin.getZ() + z, direction, frame, viewport);
            }
        }
    }

    private void tryVisitNode(WriteQueue<RenderSection> queue, int x, int y, int z, int direction, int frame, Viewport viewport) {
        RenderSection section = this.getRenderSection(x, y, z);
        if (section == null || !OcclusionCuller.isWithinFrustum(viewport, section)) {
            return;
        }
        OcclusionCuller.visitNode(queue, section, GraphDirectionSet.of(direction), frame);
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sections.get(SectionPos.asLong((int)x, (int)y, (int)z));
    }
}

