/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.occlusion;

import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirection;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirectionSet;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.VisibilityGraph;
import net.caffeinemc.mods.sodium.client.util.collections.BitArray;
import net.minecraft.client.renderer.chunk.VisibilitySet;

public class DirectionalVisGraph
implements VisibilityGraph {
    private static final int DX = 1;
    private static final int DZ = 16;
    private static final int DY = 256;
    private static final int SIZE = 4096;
    private final BitArray blocks = new BitArray(4096);
    private int filled = 0;

    private static int getIndex(int x, int y, int z) {
        return x | z << 4 | y << 8;
    }

    private static int getX(int index) {
        return index & 0xF;
    }

    private static int getY(int index) {
        return index >> 8 & 0xF;
    }

    private static int getZ(int index) {
        return index >> 4 & 0xF;
    }

    @Override
    public void setOpaque(int x, int y, int z) {
        this.blocks.set(DirectionalVisGraph.getIndex(x, y, z));
        ++this.filled;
    }

    @Override
    public VisibilitySet resolve() {
        VisibilitySet visibilitySet = new VisibilitySet();
        if (this.filled == 4096) {
            visibilitySet.setAll(false);
            return visibilitySet;
        }
        if (this.filled < 256) {
            visibilitySet.setAll(true);
            return visibilitySet;
        }
        short[] stackPos = new short[4096];
        byte[] stackDirs = new byte[4096];
        for (int originDirection = 0; originDirection < 6; ++originDirection) {
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 15;
            int maxY = 15;
            int maxZ = 15;
            switch (originDirection) {
                case 0: {
                    maxY = 0;
                    break;
                }
                case 1: {
                    minY = 15;
                    break;
                }
                case 2: {
                    maxZ = 0;
                    break;
                }
                case 3: {
                    minZ = 15;
                    break;
                }
                case 4: {
                    maxX = 0;
                    break;
                }
                case 5: {
                    minX = 15;
                }
            }
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        int index = DirectionalVisGraph.getIndex(x, y, z);
                        if (this.blocks.get(index)) continue;
                        this.search(visibilitySet, stackPos, stackDirs, originDirection, x, y, z);
                    }
                }
            }
        }
        return visibilitySet;
    }

    private void search(VisibilitySet visibilitySet, short[] stackPos, byte[] stackDirs, int originFace, int startX, int startY, int startZ) {
        BitArray visited = this.blocks.copy();
        int stackSize = 0;
        int originIndex = DirectionalVisGraph.getIndex(startX, startY, startZ);
        stackPos[stackSize++] = (short)originIndex;
        stackDirs[0] = -1;
        visited.set(originIndex);
        int connectedFaces = GraphDirectionSet.of(originFace);
        while (stackSize > 0) {
            int stackIndex = stackSize - 1;
            short currentIndex = stackPos[stackIndex];
            int currentX = DirectionalVisGraph.getX(currentIndex);
            int currentY = DirectionalVisGraph.getY(currentIndex);
            int currentZ = DirectionalVisGraph.getZ(currentIndex);
            byte completedDir = stackDirs[stackIndex];
            int nextDir = completedDir + 1;
            if (nextDir == 6) {
                --stackSize;
                continue;
            }
            stackDirs[stackIndex] = (byte)nextDir;
            if (nextDir == originFace) {
                if (nextDir + 1 != 6) continue;
                --stackSize;
                continue;
            }
            int neighborX = currentX + GraphDirection.x(nextDir);
            int neighborY = currentY + GraphDirection.y(nextDir);
            int neighborZ = currentZ + GraphDirection.z(nextDir);
            if (neighborX < 0 || neighborX >= 16 || neighborY < 0 || neighborY >= 16 || neighborZ < 0 || neighborZ >= 16) {
                if ((connectedFaces |= GraphDirectionSet.of(nextDir)) != 63) continue;
                break;
            }
            int neighborIndex = DirectionalVisGraph.getIndex(neighborX, neighborY, neighborZ);
            if (visited.getAndSet(neighborIndex)) continue;
            stackPos[stackSize] = (short)neighborIndex;
            stackDirs[stackSize] = -1;
            ++stackSize;
        }
        for (int direction = 0; direction < 6; ++direction) {
            if (!GraphDirectionSet.contains(connectedFaces, direction)) continue;
            visibilitySet.set(GraphDirection.toEnum(originFace), GraphDirection.toEnum(direction), true);
        }
    }
}

