/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortItemsProvider;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.core.SectionPos;

public interface RenderListProvider
extends SortItemsProvider {
    public ObjectArrayList<ChunkRenderList> getUnsortedRenderLists();

    public Map<TaskQueueType, ArrayDeque<RenderSection>> getTaskLists();

    public boolean needsRevisitForPendingUpdates();

    public boolean orderIsSorted();

    default public SortedRenderLists createRenderLists(Viewport viewport) {
        SectionPos sectionPos = viewport.getChunkCoord();
        ObjectArrayList<ChunkRenderList> unsorted = this.getUnsortedRenderLists();
        int cameraX = sectionPos.getX() >> RenderRegion.REGION_WIDTH_SH;
        int cameraY = sectionPos.getY() >> RenderRegion.REGION_HEIGHT_SH;
        int cameraZ = sectionPos.getZ() >> RenderRegion.REGION_LENGTH_SH;
        int size = unsorted.size();
        int[] sortItems = this.ensureSortItemsOfLength(size);
        for (int i = 0; i < size; ++i) {
            RenderRegion region = ((ChunkRenderList)unsorted.get(i)).getRegion();
            int x = Math.abs(region.getX() - cameraX);
            int y = Math.abs(region.getY() - cameraY);
            int z = Math.abs(region.getZ() - cameraZ);
            sortItems[i] = x + y + z << 16 | i;
        }
        IntArrays.unstableSort((int[])sortItems, (int)0, (int)size);
        ObjectArrayList sorted = new ObjectArrayList(size);
        for (int i = 0; i < size; ++i) {
            int key = sortItems[i];
            ChunkRenderList renderList = (ChunkRenderList)unsorted.get(key & 0xFFFF);
            sorted.add((Object)renderList);
        }
        for (ChunkRenderList list : sorted) {
            list.prepareForRender(sectionPos, this);
        }
        return new SortedRenderLists((ObjectArrayList<ChunkRenderList>)sorted);
    }
}

